% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELMSO.R
\name{ELMSO}
\alias{ELMSO}
\title{Main ELMSO Function}
\usage{
ELMSO(z, CPM = NULL, a = NULL, tau = NULL, step = 0.05,
  size = 100, tol = 10^-3, iters = 200)
}
\arguments{
\item{z}{An n by p matrix of pageviews}

\item{CPM}{A p-dimensional vector of the average CPM values at each website. This is used to calculate the cost curve from a shifted logistic function. You may instead enter values for a p-dimensional "a" vector to define your own shifted logistic cost curve.}

\item{a}{A p-dimensional vector of values controlling the steepness of the shifted logistic cost curve. You may instead enter values for a p-dimensional vector of average CPM values to have the curve calculated for you.}

\item{tau}{A p-dimensional vector of total pageviews (in thousands) for each website. Defaults to the total pageviews in the matrix for each website (i.e., assumes z matrix represents all website pageviews) divided by 1000.}

\item{step}{A value to control the step size of the lambda grid (distance between budget points). Default is 0.05.}

\item{size}{A value to control the number of lambda values tried (number of budget points). Default is 100.}

\item{tol}{A value to control the convergence tolerance of the coordinate descent procedure. Default is 10^-3.}

\item{iters}{A value to control the number of iterations until algorithm should exit if convergence tolerance is not reached. Default is 200.}
}
\value{
bid: A matrix of bid values by website at each budget

spend: a matrix of total spend by website at each budget

budget:  a vector of budget values

lambda: a vector of lambda values

a: a vector of a values (used to calculate shifted logistic curves and reach in reach.ELMSO function)
}
\description{
This function allows you to allocate budget to a set of websites based on the cost curve of the websites
and a matrix of pageviews for those sites.
}
\examples{
z=matrix(round(abs(rnorm(5000,0,0.7))),1000,5)
CPM.avg=c(3,4,5,6,7)
tau.values=rep(1000,5) #Note tau here is in thousands of pageviews

allocation=ELMSO(z=z,CPM=CPM.avg,tau=tau.values)
allocation$bid
allocation$spend
allocation$budget
allocation$lambda
allocation$a
}
\references{
Courtney Paulson, Lan Luo, and Gareth M. James (2018) Efficient Large-Scale Internet Media Selection Optimization for Online Display Advertising. Journal of Marketing Research: August 2018, Vol. 55, No. 4, pp. 489-506.
}
