% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{ELCICglm}
\alias{ELCICglm}
\title{Variable selection based on ELCIC under the syntax of GLM (Main function).}
\usage{
ELCICglm(models, data, family)
}
\arguments{
\item{models}{A list of formulas. See the corresponding documentation to glm.}

\item{data}{A data frame containing the variables in the model.}

\item{family}{A description of the error distribution and link function to be used in the model.
The details are given under "Details".}
}
\value{
A list with two items: model selection results based on ELCIC, AIC, BIC, and GIC;
An object of "glm" based on the selected model.
}
\description{
The function \code{\link{ELCICglm}} provides the variable selection under the syntax of the GLM package.
}
\details{
Three commonly used distributions are considered: "gaussian", "poisson", "binomial".
For the current package, the identity link is considered for a "gaussian" distribution;
the log link is considered for a "poisson" distribution; the logit link is considered for a "binomial" distribution;
}
\examples{
## tests
# load data
data(glmsimdata)
dat <- data.frame(y=glmsimdata$y, glmsimdata$x) ####x is a covariate matrix.
models <- list(y~x1, y~x1+x2, y~x1+x2+x3)
output<-ELCICglm(models, dat, poisson())
output$model.selection
output$glm.output

}
