% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{ELCIC.glm}
\alias{ELCIC.glm}
\title{The whole variable selection procedure for mean structure in GLM}
\usage{
ELCIC.glm(x,y,candidate.sets,name.var.sets=NULL,dist)
}
\arguments{
\item{x}{A matrix containing covariates. The first column should contain all ones corresponding to the intercept if the intercept is expected in the mean structure.}

\item{y}{A vector containing outcomes.}

\item{candidate.sets}{A list containing index corresponding to candidate covariates in each candidate model. See more in details section.}

\item{name.var.sets}{A list containing names of candidate covariates corresponding to each candidate model. The names should be subset of column names of the x matrix. See more in details section.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}
}
\value{
A matrix with each element containing ELCIC value for each candidate model (in columns) and (in rows)
}
\description{
The function \code{\link{ELCIC.glm}} provides the overall procedure for variable selection in GLM.
}
\details{
"x" and "y" should be all observed. The corresponding individual data will be deleted if any missingness is detected.

Either arguments "candidate.sets" or "name.var.sets" is used to identify the set of candidate mean model. If both arguments are provided, only the argument "name.var.sets" will be used.
}
\examples{
## tests
# load data
data(glmsimdata)
x<-glmsimdata$x
y<-glmsimdata$y
#candidate model index
candidate.sets<-list(c(1,2),c(1,2,3),c(1,2,3,4))
criteria<-ELCIC.glm(x, y, candidate.sets, name.var.sets = NULL, dist="poisson")
criteria

}
