% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intELtest.R
\name{intELtest}
\alias{intELtest}
\title{The integrated likelihood ratio test}
\usage{
intELtest(data, g1 = 1, t1 = 0, t2 = Inf, sided = 2, nboot = 1000,
  wt = "p.event", alpha = 0.05, compo = FALSE, seed = 1011,
  nlimit = 200)
}
\arguments{
\item{data}{a data frame/matrix with 3 columns. The first column is
the survival time. The second is the censoring indicator. The last is
the grouping variable. An example as the input to \code{data} provided is
\code{\link{hepatitis}}.}

\item{g1}{the group with the longer survival that
should take a value from the third column of \code{data}}

\item{t1}{pre-specified \eqn{t_1} based on domain knowledge
with the default value of \eqn{0}}

\item{t2}{pre-specified \eqn{t_2} based on domain knowledge
with the default value of \eqn{\infty}}

\item{sided}{2 if two-sided test, and 1 if one-sided test.
It assumes the default value of 2.}

\item{nboot}{number of bootstrap replications in calculating critical values}

\item{wt}{a string for the integral statistic with a specific weight function.
There are four types of integral statistics provided: \code{"p.event"}, \code{"dt"},
\code{"db"}, and \code{"dF"}. See 'Details' for more about the integral statistics.}

\item{alpha}{pre-specified significance level of the test}

\item{compo}{A logical value specifying whether to change the local statistics at time points 
outside the overlapping region of the two samples. The default is FALSE. TRUE if uses a 
functional of the difference between the Kaplan--Meier estimators (see "Details" for more).}

\item{seed}{the parameter to \code{\link[=Random]{set.seed}} for the random number generator in \R.
The \code{set.seed} is used implicitly in \code{intELtest}.}

\item{nlimit}{the splitting unit. To deal with large data problems, the bootstrap algorithm is
to split the number of bootstrap replicates into \code{nsplit} parts. The number \code{nsplit}
is the smallest integer not less than \eqn{\left\| U\right\|/}\code{nlimit}.}
}
\value{
\code{intELtest} returns a list with three elements:
\itemize{
   \item \code{critval} the critical value
   \item \code{teststat} the resulting integrated test statistic
   \item \code{pvalue} the p-value based on the integrated statistic
}
}
\description{
\code{intELtest} gives a class of the weighted likelihood ratio statistics:
\deqn{\sum_{t\in U}w(t)\{-2\log R(t)\},}
where \eqn{w(t)} is an objective weight function, and \eqn{R(t)} is an empirical likelihood
(EL) ratio that compares two survival functions at each time point \eqn{t} in the set of
observed uncensored lifetimes, \eqn{U}.
}
\details{
\code{intELtest} calculates the weighted likelihood ratio statistics:
\deqn{\sum_{i=1}^{h}w_i\cdot \{-2\log R(t_i)\},}
where \eqn{w_1,...,w_h} are the values of the weight function evaluated at
the distinct ordered uncensored times \eqn{t_1,...,t_h} in \eqn{U}.
There are four types of weight functions considered.
\itemize{
   \item (\code{wt = "dt"}) \cr
     By means of an extension of the integral statistic derived by Pepe and Fleming (1989),
     \deqn{w_i=\left\{\begin{array}{ll}t_{i+1}-t_i & \textrm{if }i\neq h\\ 0 & \textrm{if }i=h\end{array}\right.}
   \item (\code{wt = "p.event"}) \cr
     According to the integral statistic derived by Uno et al. (2013):
     \deqn{w_i=\frac{1}{n_1+n_2},}
     where \eqn{n_1} and \eqn{n_2} are the sample sizes of each group.
     The role of \eqn{w_i} assigns equal weight \eqn{1/n} to each observation when no
     tie is involved (\eqn{n = n_1 + n_2}); otherwise, it assigns heavy weight to
     the observations with multiplicity.
   \item (\code{wt = "dF"}) \cr
     Based on the integral statistic built by Barmi and McKeague (2013),
     the weight function is the derivative of the empirical distribution function \eqn{\hat{F}(t)}. 
     \deqn{w_i=\left.{\frac{d\hat{F}(t)}{dt}}\right|_{t=t_i}}
     This is an empirical version of taking expectation.
   \item (\code{wt = "db"}) \cr
     The weight function is of the form:
     \deqn{w_i=\left.\frac{d\hat{b}(t)}{dt}\right|_{t=t_i}}
     with \eqn{\hat{b}(t)=\hat{\sigma}^2(t)/(1+\hat{\sigma}^2(t))}.
     The \eqn{\hat{b}(t)} is chosen so that the limiting distribution
     \deqn{\int^{x_2}_{x_1}\frac{B^2_+(x)}{x(1 - x)}dx}
     is the same as the asymptotic null distribution in Barmi and McKeague (2013) with the
     \eqn{[x_1, x_2]} restriction.
}
For time points outside the overlapping region of the two samples, we also consider an alternative local statistic 
by taking a functional of the difference between the KM estimators inspired by Pepe and Fleming (1989). Here we 
take a standardized square of the difference for two-sided testing and the positive part of that for one-sided testing, 
inspired from the self-studentization property of EL.
}
\examples{
library(EL2Surv)
intELtest(hepatitis, 1, sided = 2, wt = "p.event")

## OUTPUT:
## $critval
## [1] 0.8993514
## 
## $teststat
## [1] 1.406029
## 
## $pvalue
## [1] 0.012

}
\references{
\itemize{
   \item H. W. Chang, "Empirical likelihood tests for stochastic
     ordering based on censored and biased data," \emph{Columbia University Academic Commons} (2014).
     \url{http://academiccommons.columbia.edu/catalog/ac\%3A177230}
   \item M. S. Pepe and T. R. Fleming, "Weighted Kaplan-Meier
     Statistics: A Class of Distance Tests for Censored Survival Data," \emph{Biometrics},
     Vol. 45, No. 2, pp. 497-507 (1989).
     \url{https://www.jstor.org/stable/2531492?seq=1#page_scan_tab_contents}
   \item H. Uno, L. Tian, B. Claggett, and L. J. Wei, "A versatile test for equality of
     two survival functions based on weighted differences of Kaplan-Meier curves,"
     \emph{Statistics in Medicine}, Vol. 34, No. 28, pp. 3680-3695 (2015).
     \url{http://onlinelibrary.wiley.com/doi/10.1002/sim.6591/abstract}
   \item H. E. Barmi and I. W. McKeague, "Empirical likelihood-based tests
     for stochastic ordering," \emph{Bernoulli}, Vol. 19, No. 1, pp. 295-307 (2013).
     \url{https://projecteuclid.org/euclid.bj/1358531751}
}
}
\seealso{
\code{\link{hepatitis}}, \code{\link{supELtest}}, \code{\link{ptwiseELtest}}
}
