% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatDate.R
\name{formatDate}
\alias{formatDate}
\title{Function to transform dates into "Date" R format}
\usage{
formatDate(input, dateColumn, dateFormat = "\%y/\%m/\%d", verbose = FALSE)
}
\arguments{
\item{input}{A \code{data.frame} object with at least one column of dates.}

\item{dateColumn}{The name of the column containing the date.}

\item{dateFormat}{By default \code{'\%y/\%m/\%d'}. Change it to the specific structure of your date format.}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get an on-time log from the function.}
}
\value{
An object of class \code{data.frame} with the date column transform into 'Date' R class.
}
\description{
Given a \code{data.frame} object with a column of dates in 'character' format, 
it generates a new \code{data.frame} object with the dates transformed into 
"Date" R format.
}
\examples{

dataset <- read.csv2(system.file("extdata",
                                   "nhdsSubset.csv",
                                   package="EHRtemporalVariability"), 
                     sep  = ",",
                     header = TRUE, 
                     na.strings = "", 
                     colClasses = c( "character", "numeric", "factor",
                                     "numeric" , rep( "factor", 22 ) ) )
                     
datasetFormatted <- formatDate( 
              input         = dataset, 
              dateColumn    = "date", 
              dateFormat    = "\%y/\%m",
             )
}
