% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runGroups.R
\name{runGroups}
\alias{runGroups}
\title{Runs a comparison of any group of years in the record.}
\usage{
runGroups(eList, windowSide, group1firstYear, group1lastYear,
  group2firstYear, group2lastYear, surfaceStart = NA, surfaceEnd = NA,
  flowBreak = FALSE, Q1EndDate = NA, QStartDate = NA,
  QEndDate = NA, wall = FALSE, oldSurface = FALSE, fractMin = 0.75,
  sample1EndDate = NA, sampleStartDate = NA, sampleEndDate = NA,
  paStart = 10, paLong = 12, minNumObs = 100, minNumUncen = 50,
  windowY = 7, windowQ = 2, windowS = 0.5, edgeAdjust = TRUE,
  verbose = TRUE)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{windowSide}{integer. The width of the flow normalization window on each side of the year being estimated.
A common value is 7, but no default is specified.  If stationary flow normalization is to be used, then windowSide = 0 (this means that 
flow-normalization period for all years is the same).}

\item{group1firstYear}{integer year. Starting year of first group.}

\item{group1lastYear}{integer year. Ending year of first group.}

\item{group2firstYear}{integer year. Starting year of second group.}

\item{group2lastYear}{integer year. Ending year of second group.}

\item{surfaceStart}{The Date (or character in YYYY-MM-DD) that is the start of the WRTDS model to be estimated and the first of the 
daily outputs to be generated. Default is NA, which means that the surfaceStart is based on the date of the first sample.}

\item{surfaceEnd}{The Date (or character in YYYY-MM-DD) that is the end of the WRTDS model to be estimated and the last of the daily outputs 
to be generated.  Default is NA, which means that the surfaceEnd is based on the date of the last sample.}

\item{flowBreak}{logical. Is there an abrupt break in the discharge record, default is FALSE.}

\item{Q1EndDate}{The Date (as character in YYYY-MM-DD) which is the last day, just before the flowBreak.}

\item{QStartDate}{The first Date (as character in YYYY-MM-DD) used in the  flow normalization method.  Default is 
NA, which makes the QStartDate become the first Date in eList$Daily.}

\item{QEndDate}{The last Date (as character in YYYY-MM-DD) used in the flow normalization method.  Default is NA, 
which makes the QEndDate become the last Date in eList$Daily.}

\item{wall}{logical. Whether there is an abrupt break in the concentration versus discharge relationship.  Default is FALSE}

\item{oldSurface}{logical specifying whether to use the original surface, or create a new one. Default is FALSE.}

\item{fractMin}{numeric specifying the minimum fraction of the observations required to run the weighted regression, default is 0.75. The
minimum number will be the maximum of minNumObs and fractMin multiplied by total number of observations.}

\item{sample1EndDate}{The Date (as character in YYYY-MM-DD) of the last date just before the wall. Default = NA. 
A date must be specified if wall = TRUE.}

\item{sampleStartDate}{The Date (as character in YYYY-MM-DD) of the first sample to be used. Default is NA which sets it 
to the first Date in eList$Sample.}

\item{sampleEndDate}{The Date (as character in YYYY-MM-DD) of the last sample to be used. 
Default is NA which sets it to the last Date in eList$Sample.}

\item{paStart}{numeric integer specifying the starting month for the period of analysis, 1<=paStart<=12, default is 10  (used when period is water year).}

\item{paLong}{numeric integer specifying the length of the period of analysis, in months, 1<=paLong<=12, default is 12.}

\item{minNumObs}{numeric specifying the miniumum number of observations required to run the weighted regression, default is 100}

\item{minNumUncen}{numeric specifying the minimum number of uncensored observations to run the weighted regression, default is 50}

\item{windowY}{numeric specifying the half-window width in the time dimension, in units of years, default is 7}

\item{windowQ}{numeric specifying the half-window width in the discharge dimension, units are natural log units, default is 2}

\item{windowS}{numeric specifying the half-window with in the seasonal dimension, in units of years, default is 0.5}

\item{edgeAdjust}{logical specifying whether to use the modified method for calculating the windows at the edge of the record.
The edgeAdjust method tends to reduce curvature near the start and end of record.  Default is TRUE.}

\item{verbose}{logical specifying whether or not to display progress message}
}
\value{
data frame with the following columns:
\tabular{lll}{
Name \tab Description \cr
Total Change \tab   The difference between the results for year2 - year1\cr
CQTC \tab this number is the difference between between the two years, but only the part that is due to the change 
in the CQR. It is x20 - x10. In the results reported above as, "Concentration v. Q Trend 
Component" it is computed as 100 * (x20 - x10) / x11 \cr
QTC \tab  The difference between the two years, but only the part that is due to the change in the QD. 
It is the Total Change - CQTC. Or it can be stated as x22 - x11 - x20 + x10. In the results reported above as, "Q Trend Component" 
it is computed as 100 * (x22 - x11 - x20 + x10) / x11. \cr
x10 \tab The results using the concentration versus discharge relationship (CQR) for year 1, but using the discharge 
distribution (QD) for the entire period of record (starting with QStartDate and 
ending with QEndDate, or if they aren't specified, it is all the discharge data 
in the Daily data frame).\cr
x11 \tab The results using the CQR for year 1, but using the QD specified by the user for year 1.\tab \cr
x20 \tab The results using the CQR for year 2, but using the QD for the entire period. \cr
x22 \tab The results for the CQR for year 2, but using the QD specified by the user for year 2. \cr
}
}
\description{
\code{runGroups} provides comparisons of results, in terms of 
flow-normalized concentration and flow-normalzed flux for any groups of years
of years in the water quality record.  Comparison could involve the 
use of the "wall" and/or use of "generalized flow normalization".  
These two concepts are described in detail in the vignette.
}
\examples{
eList <- Choptank_eList
\dontrun{

#Option 1:  Use all years for group flow normalization.
groupOut_1 <- runGroups(eList,  windowSide = 0,
                       group1firstYear = 1980, group1lastYear = 1990,
                       group2firstYear = 1995, group2lastYear = 2005)

# Option 2: Use sliding window.
#                In each case it is a 15 year window (15 = 1 + 2*7)

groupOut_2 <- runGroups(eList,  windowSide = 7,
                       group1firstYear = 1980, group1lastYear = 1990,
                       group2firstYear = 1995, group2lastYear = 2005)

# Option 3: Flow normalization is based on splitting the flow record at 1990-09-30
#                But in years before the break it uses all flow data from before the break,
#                and years after the break uses all flow data after the break

groupOut_3 <- runGroups(eList,  windowSide = 0,
                       group1firstYear = 1980, group1lastYear = 1990,
                       group2firstYear = 1995, group2lastYear = 2005,
                       flowBreak = TRUE, 
                       Q1EndDate = "1990-09-30")

# Option 4: Flow normalization is based on splitting the flow record at 1990-09-30
#                but before the break uses a 15 year window of years before the break
#                after the break uses a 15 year window of years after the break
groupOut_4 <- runGroups(eList,  windowSide = 7,
                       group1firstYear = 1980, group1lastYear = 1990,
                       group2firstYear = 1995, group2lastYear = 2005,
                       flowBreak = TRUE, 
                       Q1EndDate = "1990-09-30")

}
}
