% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupYears.R
\name{setupYears}
\alias{setupYears}
\title{Creates the AnnualResults data frame from the Daily data frame}
\usage{
setupYears(localDaily, paLong = 12, paStart = 10)
}
\arguments{
\item{localDaily}{data frame containing the daily values, default is Daily}

\item{paLong}{numeric integer specifying the length of the period of analysis, in months, 1<=paLong<=12, default is 12}

\item{paStart}{numeric integer specifying the starting month for the period of analysis, 1<=paStart<=12, default is 10}
}
\value{
A data frame 'AnnualResults' of numeric values with the following columns
\tabular{lll}{
Name \tab Description \cr
DecYear \tab Middle of the period in decimal years\cr
Q \tab Mean discharge, in m^3/s\cr
Conc \tab Estimated mean concentration, in mg/L\cr
Flux \tab Estimated mean flux, in kg/day\cr
FNConc \tab Flow-normalized concentration, in mg/L\cr
FNFlux \tab Flow-normalized flux, in kg/day\cr
GenConc \tab Generalized mean concentration, in mg/L. This column is only returned if the WRTDSKalman function was run, which gives the 
eList$Daily data frame a column "GenConc".\cr
GenFlux \tab Generalized mean flux, in kg/day. This column is only returned if the WRTDSKalman function was run, which gives the 
eList$Daily data frame a column "GenFlux".\cr
PeriodLong \tab Length of period of analysis (paLong), in months\cr
PeriodStart \tab Starting month of period of analysis (paStart), in months (1 = January)\cr
}
}
\description{
This function aggregates the results stored on a daily basis in the Daily data frame
  and stores the average values of these in the new data frame called AnnualResults.
     Note that the flux values are rates (kg/day) and not a mass (kg).
     The "annual values" can be a full 12 months, or they can be shorter. 
     See manual to understand paLong and paStart arguments. 
     The simplest case, a Water Year (October through September), would have
     paLong=12, and paStart=10. 
     A calendar year would be paLong=12 and paStart=1. 
     A winter season of Dec, Jan, Feb would be paLong=3 and paStart=12
}
\examples{
eList <- Choptank_eList
Daily <- getDaily(eList)
AnnualResults <- setupYears(Daily, 4, 10)


}
\keyword{statistics}
\keyword{water-quality}
