# Updating this list will not automatically update the objects available in the package.
# If you update this list, run the code to generate fluxConst or qUnit, then save the image as sysdata.rda

fluxConst <- list(poundsDay = new("fluxUnit", 
                                  shortName = "   lbs/day  ",   
                                  unitFactor = 2.204623,    
                                  unitName = "pounds/day",
                                  unitExpress = expression("Flux in pounds/day"),
                                  unitExpressTiny = expression("Flux (lbs/d)"),
                                  unitEstimate = expression("Estimated flux in pounds/day"),
                                  unitEstimateTiny = expression("Est. flux (lbs/d)"),
                                  unitUSGS = "Flux in pounds per day",
                                  shortCode = 1),
                  tonsDay = new("fluxUnit", 
                                shortName = "   tons/day  ",  
                                unitFactor = 0.001102,    
                                unitName = "tons/day",
                                unitExpress = expression("Flux in tons/day"),
                                unitExpressTiny = expression("Flux (tons/d)"),
                                unitEstimate = expression("Estimated flux in tons/day"),
                                unitEstimateTiny = expression("Est. flux (tons/d)"),
                                unitUSGS = "Flux in tons per day",
                                shortCode = 2),
                  kgDay = new("fluxUnit", 
                              shortName = "    kg/day  ",   
                              unitFactor = 1,
                              unitName = "kg/day",
                              unitExpress = expression("Flux in kg/day"),
                              unitExpressTiny = expression("Flux (kg/d)"),
                              unitEstimate = expression("Estimated flux in kg/day"),
                              unitEstimateTiny = expression("Est. flux (kg/d)"),
                              unitUSGS = "Flux in kilograms per day",
                              shortCode = 3),
                  thousandKgDay = new("fluxUnit", 
                                      shortName = " 10^3 kg/day",
                                      unitFactor = 0.001,
                                      unitName = "thousands of kg/day",
                                      unitExpress = expression(paste("Flux in ",10^3*kg/day)),
                                      unitExpressTiny = expression(paste("Flux ", "(", 10^3*kg/d, ")")),
                                      unitEstimate = expression(paste("Estimated flux in ",10^3*kg/day)),
                                      unitEstimateTiny = expression(paste("Est. flux ", "(", 10^3*kg/d, ")")),
                                      unitUSGS = "Flux in thousands of kilograms per day",
                                      shortCode = 4),
                  tonsYear = new("fluxUnit", 
                                 shortName = "   tons/yr  ",
                                 unitFactor = 0.402619,
                                 unitName = "tons/year",
                                 unitExpress = expression("Flux in tons/year"),
                                 unitExpressTiny = expression("Flux (tons/yr)"),
                                 unitEstimate = expression("Estimated flux in tons/year"),
                                 unitEstimateTiny = expression("Est. flux (tons/yr)"),
                                 unitUSGS = "Flux in tons per year",
                                 shortCode = 5),
                  thousandTonsYear = new("fluxUnit", 
                                         shortName = "  10^3 tons/yr",
                                         unitFactor = 0.000402619,
                                         unitName = "thousands of tons/year",
                                         unitExpress = expression(paste("Flux in ",10^3*tons/yr)),
                                         unitExpressTiny = expression(paste("Flux ", "(", 10^3*tons/yr, ")")),
                                         unitEstimate = expression(paste("Estimated flux in ",10^3*tons/yr)),
                                         unitEstimateTiny = expression(paste("Est. flux ", "(", 10^3*tons/yr, ")")),
                                         unitUSGS = "Flux in thousands of tons per year",
                                         shortCode = 6),
                  millionTonsYear = new("fluxUnit",
                                        shortName = "  10^6 tons/yr",
                                        unitFactor = 4.02619e-07,
                                        unitName = "millions of tons/year",
                                        unitExpress = expression(paste("Flux in ",10^6*tons/yr)),
                                        unitExpressTiny = expression(paste("Flux ", "(", 10^6*tons/yr, ")")),
                                        unitEstimate = expression(paste("Estimated flux in ",10^6*tons/yr)),
                                        unitEstimateTiny = expression(paste("Est. flux ", "(", 10^6*tons/yr, ")")),
                                        unitUSGS = "Flux in millions of tons per year",
                                        shortCode = 7),
                  thousandKgYear = new("fluxUnit",
                                       shortName = "   10^3 kg/yr",
                                       unitFactor = 0.36525,
                                       unitName = "thousands of kg/year",
                                       unitExpress = expression(paste("Flux in ",10^3*kg/yr)),
                                       unitExpressTiny = expression(paste("Flux ", "(", 10^3*kg/yr, ")")),
                                       unitEstimate = expression(paste("Estimated flux in ",10^3*kg/yr)),
                                       unitEstimateTiny = expression(paste("Est. flux ", "(", 10^3*kg/yr, ")")),
                                       unitUSGS = "Flux in thousands of kilograms per year",
                                       shortCode = 8),
                  millionKgYear = new("fluxUnit",
                                      shortName = "   10^6 kg/yr",
                                      unitFactor = 0.00036525,
                                      unitName = "millions of kg/year",
                                      unitExpress = expression(paste("Flux in ",10^6*kg/yr)),
                                      unitExpressTiny = expression(paste("Flux ", "(", 10^6*kg/yr, ")")),
                                      unitEstimate = expression(paste("Estimated flux in ",10^6*kg/yr)),
                                      unitEstimateTiny = expression(paste("Est. flux ", "(", 10^6*kg/yr, ")")),
                                      unitUSGS = "Flux in millions of kilograms per year",
                                      shortCode = 9),
                  billionKgYear = new("fluxUnit",
                                      shortName = "   10^9 kg/yr",
                                      unitFactor = 3.6525e-07,
                                      unitName = "billions of kg/year",
                                      unitExpress = expression(paste("Flux in",10^9*kg/yr)),
                                      unitExpressTiny = expression(paste("Flux ", "(", 10^9*kg/yr, ")")),
                                      unitEstimate = expression(paste("Estimated flux in",10^9*kg/yr)),
                                      unitEstimateTiny = expression(paste("Est. flux ", "(", 10^9*kg/yr, ")")),
                                      unitUSGS = "Flux in billions of kilograms per year",
                                      shortCode = 10),
                  thousandTonsDay = new("fluxUnit",
                                        shortName = " 10^3 tons/day",
                                        unitFactor = 1.102e-06,
                                        unitName = "thousands of tons/day",
                                        unitExpress = expression(paste("Flux in ",10^3*tons/day)),
                                        unitExpressTiny = expression(paste("Flux ", "(", 10^3*tons/d, ")")),
                                        unitEstimate = expression(paste("Estimated flux in ",10^3*tons/day)),
                                        unitEstimateTiny = expression(paste("Est. flux ", "(", 10^3*tons/d, ")")),
                                        unitUSGS = "Flux in thousands of tons per day",
                                        shortCode = 11),
                  millionKgDay = new("fluxUnit",
                                     shortName = "   10^6 kg/day",
                                     unitFactor = 1.000e-06,
                                     unitName = "millions of kg/day",
                                     unitExpress = expression(paste("Flux in ",10^6*kg/day)),
                                     unitExpressTiny = expression(paste("Flux ", "(", 10^6*kg/d, ")")),
                                     unitEstimate = expression(paste("Estimated flux in ",10^6*kg/day)),
                                     unitEstimateTiny = expression(paste("Est. flux ", "(", 10^6*kg/d, ")")),
                                     unitUSGS = "Flux in millions of kilograms per day",
                                     shortCode = 12),
                  kgYear = new("fluxUnit",
                                     shortName = "    kg/yr   ",
                                     unitFactor = 365.25,
                                     unitName = "kg/year",
                                     unitExpress = expression("Flux in kg/year"),
                                     unitExpressTiny = expression("Flux (kg/yr)"),
                                     unitEstimate = expression("Estimated flux in kg/year"),
                                     unitEstimateTiny = expression("Est. flux in kg/yr"),
                                     unitUSGS = "Flux in kilograms per year",
                                     shortCode = 13)

)

qConst <- list(cfs = new("qUnit",
                          qShortName = "   cfs  ",
                          qUnitFactor = 35.314667,
                          qUnitName = "Cubic Feet per Second",
                          qUnitExpress = expression(paste("Discharge in ",ft^3/s)),
                          qUnitTiny = expression(paste("Discharge ", "(", ft^3/s, ")")),
                          shortCode = 1,
                          unitUSGS = "Discharge in cubic feet per second"
                          ),
                cms = new("qUnit",
                          qShortName = "   cms  ",
                          qUnitFactor = 1,
                          qUnitName = "Cubic Meters per Second",
                          qUnitExpress = expression(paste("Discharge in ",m^3/s)),
                          qUnitTiny = expression(paste("Discharge ", "(", m^3/s, ")")),
                          shortCode = 2,
                          unitUSGS = "Discharge in cubic meters per second"
                          ),
                thousandCfs = new("qUnit",
                          qShortName = "10^3 cfs",
                          qUnitFactor = 0.035314667,
                          qUnitName = "Thousand Cubic Feet per Second",
                          qUnitExpress = expression(paste("Discharge in ",10^3*ft^3/s)),
                          qUnitTiny = expression(paste("Discharge ", "(", 10^3*ft^3/s, ")")),
                          shortCode = 3,
                          unitUSGS = "Discharge in thousands of cubic feet per second"
                          ),
                thousandCms = new("qUnit",
                          qShortName = "10^3 cms",
                          qUnitFactor = 0.001,
                          qUnitName = "Thousand Cubic Meters per Second",
                          qUnitExpress = expression(paste("Discharge in ",10^3*m^3/s)),
                          qUnitTiny = expression(paste("Discharge ", "(", 10^3*m^3/s, ")")),
                          shortCode = 4,
                          unitUSGS = "Discharge in thousands of cubic meters per second"
                          ),
                mmDay = new("qUnit",
                            qShortName = "mm/day",
                            qUnitFactor = 86400000,
                            qUnitName = "Cubic Millimeters per Day",
                            qUnitExpress = expression(paste("Discharge in ",mm^3/day)),
                            qUnitTiny = expression(paste("Discharge ", "(", mm^3/day, ")")),
                            shortCode = 5,
                            unitUSGS = "Discharge in cubic millimeters per day"
                          )
#                 ,mmYear = new("qUnit",
#                           qUnitName = "Cubic Millimeters per Year",
#                           qUnitFactor = ,
#                           qUnitExpress = expression(paste("Discharge in ",mm^3/year)),
#                           qUnitTiny = expression(paste("Discharge ", "(", mm^3/year, ")")),
#                           shortCode = 6
#                           )
)

monthInfo = c(new("monthLabel",
                    monthAbbrev = "Jan",
                    monthFull = "January",
                    monthSingle = "J"
                    ),
              new("monthLabel",
                    monthAbbrev = "Feb",
                    monthFull = "February",
                    monthSingle = "F"
                    ),
              new("monthLabel",
                    monthAbbrev = "Mar",
                    monthFull = "March",
                    monthSingle = "M"
                    ),
              new("monthLabel",
                    monthAbbrev = "Apr",
                    monthFull = "April",
                    monthSingle = "A"
                    ),
              new("monthLabel",
                    monthAbbrev = "May",
                    monthFull = "May",
                    monthSingle = "M"
                    ),
              new("monthLabel",
                    monthAbbrev = "Jun",
                    monthFull = "June",
                    monthSingle = "J"
                    ),
              new("monthLabel",
                    monthAbbrev = "Jul",
                    monthFull = "July",
                    monthSingle = "J"
                    ),
              new("monthLabel",
                    monthAbbrev = "Aug",
                    monthFull = "August",
                    monthSingle = "A"
                    ),
              new("monthLabel",
                    monthAbbrev = "Sep",
                    monthFull = "September",
                    monthSingle = "S"
                    ),
              new("monthLabel",
                    monthAbbrev = "Oct",
                    monthFull = "October",
                    monthSingle = "O"
                    ),
              new("monthLabel",
                    monthAbbrev = "Nov",
                    monthFull = "November",
                    monthSingle = "N"
                    ),
              new("monthLabel",
                    monthAbbrev = "Dec",
                    monthFull = "December",
                    monthSingle = "D"
                    )
)
