% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dynEGA.Individuals.R
\name{plot.dynEGA.Individuals}
\alias{plot.dynEGA.Individuals}
\title{Plot method for \code{\link[EGAnet]{dynEGA}} objects (Level: Individual)}
\usage{
\method{plot}{dynEGA.Individuals}(x, title = "", vsize = 6, id = NULL, ...)
}
\arguments{
\item{x}{An \code{\link[EGAnet]{dynEGA}} object (Level: Individual)}

\item{title}{Character. Title of the plot}

\item{vsize}{An integer indicating the size of the nodes.
Default vsize = 6}

\item{id}{An integer or character indicating the ID of the individual to plot.}

\item{...}{Arguments passed to \code{\link[qgraph]{qgraph}}}
}
\description{
Plots the \code{\link[EGAnet]{dynEGA}} result using \code{\link[qgraph]{qgraph}}
}
\examples{
\dontrun{
# Estimate dynEGA
dyn.intra <- dynEGA(data = sim.dynEGA, n.embed = 5, tau = 1,
delta = 1, id = 21, group = 22, use.derivatives = 1,
level = "individual", model = "glasso")

#Summary of dynEGA reults
summary(dyn.intra)

# Plot EGA network
plot(dyn.intra, vsize = 6, label.prop = 1, id = "ID1")
}

}
\seealso{
\code{\link[EGAnet]{dynEGA}} to estimate the number of dimensions in multivariate time series using dynEGA.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>
}
