% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.CFA.R
\name{summary.CFA}
\alias{summary.CFA}
\title{Summary for CFA objects of \code{\link[EGAnet]{EGA}} results}
\usage{
\method{summary}{CFA}(object, ...)
}
\arguments{
\item{object}{An \code{\link[EGAnet]{CFA}} object}

\item{...}{potentially further arguments (\strong{unused currently})}
}
\description{
Returns a summary of the CFA results of \code{\link[EGAnet]{EGA}} results
}
\examples{
\dontrun{
# Estimate EGA
ega.wmt <- EGA(data = wmt2[,7:24], plot.EGA = TRUE)

}

# Esimtate CFA
cfa.wmt <- CFA(ega.obj = ega.wmt, estimator = 'WLSMV', plot.CFA = TRUE, data = wmt2)

# Summary of CFA results
summary(cfa.wmt)

}
\seealso{
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA
and \code{\link[EGAnet]{bootEGA}} to investigate the stability of EGA's estimation via bootstrap.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>
}
