% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFA.R
\name{CFA}
\alias{CFA}
\title{CFA Fit of \code{\link[EGAnet]{EGA}} Structure}
\usage{
CFA(ega.obj, data, estimator, plot.CFA = TRUE, layout = "spring", ...)
}
\arguments{
\item{ega.obj}{An \code{\link[EGAnet]{EGA}} object}

\item{data}{A dataframe with the variables to be used in the analysis}

\item{estimator}{The estimator used in the confirmatory factor analysis.
'WLSMV' is the estimator of choice for ordinal variables.
'ML' or 'WLS' for interval variables.
See \code{\link[lavaan]{lavOptions}} for more details}

\item{plot.CFA}{Logical.
Should the CFA structure with its standardized loadings be plot?
Defaults to TRUE}

\item{layout}{Layout of plot (see \code{\link[semPlot]{semPaths}}).
Defaults to "spring"}

\item{...}{Arguments passed to \code{\link[lavaan]{cfa}}}
}
\value{
Returns a list containing:

\item{fit}{Output from \code{\link[lavaan]{cfa}}}

\item{summary}{Summary output from \code{\link[lavaan]{lavaan-class}}}

\item{fit.measures}{Fit measures: chi-squared,
degrees of freedom, p-value, CFI, RMSEA, GFI, and NFI.
Additional fit measures can be applied using the
\code{\link[lavaan]{fitMeasures}} function (see examples)}
}
\description{
Verifies the fit of the structure suggested by \code{\link[EGAnet]{EGA}} using confirmatory factor analysis
}
\examples{

# Load data
wmt <- wmt2[,7:24]

\dontrun{
# Estimate EGA
ega.wmt <- EGA(data = wmt)

}

# Fit CFA model to EGA results
cfa.wmt <- CFA(ega.obj = ega.wmt, estimator = 'WLSMV', plot.CFA = TRUE, data = wmt)

# Additional fit measures
lavaan::fitMeasures(cfa.wmt$fit, fit.measures = "all")

# Load data
intel <- intelligenceBattery[,8:66]

\dontrun{
# Estimate EGA
ega.intel <- EGA(data = intel)

# Fit CFA model to EGA results
cfa.intel <- CFA(ega.obj = ega.intel, estimator = 'WLSMV', plot.CFA = TRUE,
data = intel)

}

}
\seealso{
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA and
\code{\link[EGAnet]{bootEGA}} to investigate the stability of EGA's estimation via bootstrap.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>
}
