% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EBICglasso.qgraph.R
\name{EBICglasso.qgraph}
\alias{EBICglasso.qgraph}
\title{EBICglasso from qgraph 1.4.4}
\usage{
EBICglasso.qgraph(S, n, gamma = 0.5, penalize.diagonal = FALSE,
  nlambda = 100, lambda.min.ratio = 0.01, returnAllResults = FALSE,
  checkPD = TRUE, penalizeMatrix, countDiagonal = FALSE,
  refit = FALSE, ...)
}
\arguments{
\item{S}{A covariance or correlation matrix}

\item{n}{Sample size used in computing \code{S}}

\item{gamma}{EBIC tuning parameter. 0.5 is generally a good choice.
Setting to zero will cause regular BIC to be used.}

\item{penalize.diagonal}{Should the diagonal be penalized?}

\item{nlambda}{Number of lambda values to test.}

\item{lambda.min.ratio}{Ratio of lowest lambda value compared to maximal lambda}

\item{returnAllResults}{If \code{TRUE} this function does not
return a network but the results of the entire glasso path.}

\item{checkPD}{If \code{TRUE}, the function will check if \code{S} is positive definite
and return an error if not. It is not advised to use a
non-positive definite matrix as input as (a) that can not
be a covariance matrix and (b) glasso can hang if the input is not positive definite.}

\item{penalizeMatrix}{Optional logical matrix to indicate which elements are penalized}

\item{countDiagonal}{Should diagonal be counted in EBIC computation?
Defaults to \code{FALSE}. Set to \code{TRUE} to mimic qgraph < 1.3 behavior (not recommended!).}

\item{refit}{Logical, should the optimal graph be refitted without LASSO regularization?
Defaults to \code{FALSE}.}

\item{...}{Arguments sent to \code{\link[glasso]{glasso}}}
}
\value{
A partial correlation matrix
}
\description{
This function uses the \code{\link[glasso]{glasso}} package
(Friedman, Hastie and Tibshirani, 2011) to compute a
sparse gaussian graphical model with the graphical lasso
(Friedman, Hastie & Tibshirani, 2008).
The tuning parameter is chosen using the Extended Bayesian Information criterium
(EBIC) described by Foygel & Drton (2010).
}
\details{
The glasso is run for 100 values of the tuning parameter logarithmically
spaced between the maximal value of the tuning parameter at which all edges are zero,
lambda_max, and lambda_max/100. For each of these graphs the EBIC is computed and
the graph with the best EBIC is selected. The partial correlation matrix
is computed using \code{\link{wi2net}} and returned.
}
\examples{
\donttest{
### Using wmt2 dataset from EGAnet ###
data(wmt2)

# Compute correlations:
CorMat <- cor_auto(wmt2[,7:24])

# Compute graph with tuning = 0 (BIC):
BICgraph <- EBICglasso.qgraph(CorMat, nrow(wmt2), 0)

# Compute graph with tuning = 0.5 (EBIC)
EBICgraph <- EBICglasso.qgraph(CorMat, nrow(wmt2), 0.5)
}

}
\references{
Friedman, J., Hastie, T., & Tibshirani, R. (2008).
Sparse inverse covariance estimation with the graphical lasso.
\emph{Biostatistics}, \emph{9}, 432-441.
doi: \href{https://doi.org/10.1093/biostatistics/kxm045}{10.1093/biostatistics/kxm045}

#glasso package
Jerome Friedman, Trevor Hastie and Rob Tibshirani (2011).
glasso: Graphical lasso-estimation of Gaussian graphical models.
R package version 1.7.
\url{https://CRAN.R-project.org/package=glasso}

Foygel, R., & Drton, M. (2010).
Extended Bayesian information criteria for Gaussian graphical models.
In Advances in neural information processing systems (pp. 604-612).
\url{https://papers.nips.cc/paper/4087-extended-bayesian-information-criteria-for-gaussian-graphical-models}

#psych package
Revelle, W. (2014) psych: Procedures for Personality and Psychological Research,
Northwestern University, Evanston, Illinois, USA.
R package version 1.4.4.
\url{https://CRAN.R-project.org/package=psych}

#Matrix package
Douglas Bates and Martin Maechler (2014).
Matrix: Sparse and Dense Matrix Classes and Methods.
R package version 1.1-3.
\url{https://CRAN.R-project.org/package=Matrix}
}
\author{
Sacha Epskamp <mail@sachaepskamp.com>
}
