% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBootMeanDiff.R
\name{getMegDiffConfInv}
\alias{getMegDiffConfInv}
\title{getMegDiffConfInv function}
\usage{
getMegDiffConfInv(Values, Group, GroupList, bootT, alpha, methodType)
}
\arguments{
\item{Values}{is a vector of real-number values}

\item{Group}{is a vector of categories of each real number in Values}

\item{GroupList}{is a list of names of categories ascendingly ordered by their means.}

\item{bootT}{is a number of times of sample with replacement for bootstrapping.
The default is 1000. It must be above zero}

\item{alpha}{is a significance level using in both confidence intervals and ordering inference it has the range [0,1].
The default is 0.05.}

\item{methodType}{is an option for bootstrapping methods:either  "perc" or "bca".
The "perc" is the default option.}
}
\value{
This function returns a list of mean-difference confidence intervals.

\code{MegDiffList} a list of objects that contains mean-difference confidence intervals of all possible pairs of distributions.
It contains MegDiffList[[1]],...,MegDiffList[[length(GroupList)]].

The \code{MegDiffList} consists of the following variables

\item{MegDiffList[[i]]}{ Mean-difference confidence intervals and related information of all categories that have higher means than sortedGroupList[i] category.}
}
\description{
getMegDiffConfInv is a support function for bootstrapping method.
Its main purpose is to compute a mean-difference confidence intervals between all pair of distributions.
}
