% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_package_report_checksum.R
\name{read_data_package_report_checksum}
\alias{read_data_package_report_checksum}
\title{Read data package report checksum}
\usage{
read_data_package_report_checksum(packageId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(character) A 40 character SHA-1 checksum value for the report
}
\description{
Read data package report checksum
}
\examples{
\dontrun{

# Read report checksum
packageId <- "knb-lter-luq.208.1"
checksum <- read_data_package_report_checksum(packageId)
checksum
#> "980dbf3f3cdb7395933b711b005722033bdcd12f"
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_data_package}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()},
\code{\link{read_metadata}()}
}
\concept{Accessing}
