% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_package_doi.R
\name{read_data_package_doi}
\alias{read_data_package_doi}
\title{Read data package Digital Object Identifier}
\usage{
read_data_package_doi(packageId, as_url = FALSE, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{as_url}{(logical) Returns the DOI as a URL if TRUE.}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(character) The Digital Object Identifier for \code{packageId}
}
\description{
Read data package Digital Object Identifier
}
\examples{
\dontrun{

# Read package DOI
doi <- read_data_package_doi("knb-lter-jrn.210548103.15")
doi
#> [1] "doi:10.6073/pasta/c80c0c03d22791524d4b870d2193c843"

# Read package DOI as URL
doi <- read_data_package_doi("knb-lter-jrn.210548103.15", as_url = TRUE)
doi
#> [1] "https://doi.org/10.6073/pasta/c80c0c03d22791524d4b870d2193c843"
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_data_package}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()},
\code{\link{read_metadata}()}
}
\concept{Accessing}
