% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_package_report_summary.R
\name{read_data_package_report_summary}
\alias{read_data_package_report_summary}
\title{Summarize the data package quality report}
\usage{
read_data_package_report_summary(
  packageId,
  with_exceptions = TRUE,
  env = "production"
)
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{with_exceptions}{(logical) Convert quality report warnings and errors
to R warnings and errors}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(message/warning/error) A message listing the total number of checks
resulting in valid, info, warn, and error status. Exceptions are raised if
warnings and errors are found and \code{with_exceptions} is TRUE.
}
\description{
Summarize the data package quality report
}
\examples{
\dontrun{

# Read report summary
read_data_package_report_summary("knb-lter-knz.260.4")
#> ===================================================
#>   EVALUATION REPORT
#> ===================================================
#>   
#> PackageId: knb-lter-knz.260.4
#> Report Date/Time: 2020-02-04T16:38:38
#> Total Quality Checks: 213
#> Valid: 139
#> Info: 73
#> Warn: 1
#> Error: 0
#> 
#> 
#> Warning message:
#> One or more quality checks resulted in 'warn' 
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_data_package}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()},
\code{\link{read_metadata}()}
}
\concept{Accessing}
