% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_mixed.R
\name{table_format}
\alias{table_format}
\title{Identify if a dataframe has a long or a wide format}
\usage{
table_format(
  df,
  id = get_subjid_cols(),
  ...,
  ignore_cols = get_meta_cols(0.95),
  na_rm = FALSE,
  warn = TRUE
)
}
\arguments{
\item{df}{a dataframe}

\item{id}{the identifying subject ID}

\item{...}{not used}

\item{ignore_cols}{columns to ignore. Usually meta columns (see \link{get_meta_cols}).}

\item{na_rm}{whether to consider missing values}

\item{warn}{whether to warn if ID is not found}
}
\value{
a string value in \verb{c("wide", "long", "mixed)}
}
\description{
A dataset is either in the wide format or in the long format (\href{https://towardsdatascience.com/long-and-wide-formats-in-data-explained-e48d7c9a06cb}{link}).
This function identifies the format of a dataframe with respect to a subject ID.
If a dataframe has some wide and long columns, it is considered "mixed".
}
\examples{
tm = edc_example_mixed()
sapply(tm, table_format, warn=FALSE) 
}
