% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialmaster.R
\name{read_tm_all_xpt}
\alias{read_tm_all_xpt}
\title{Read all \code{.xpt} files in a directory}
\usage{
read_tm_all_xpt(
  directory,
  ...,
  format_file = "procformat.sas",
  clean_names_fun = NULL,
  split_mixed = FALSE,
  extend_lookup = TRUE,
  datetime_extraction = NULL,
  verbose = getOption("edc_read_verbose", 1),
  key_columns = "deprecated"
)
}
\arguments{
\item{directory}{[\code{character(1)}]\cr the path to the unzipped archive using SAS_XPORT format. Will read the extraction date from the directory name.}

\item{...}{unused}

\item{format_file}{[\code{character(1)}]\cr the path to the \code{procformat.sas} file that should be used to apply formats. Use \code{NULL} to not apply formats.}

\item{clean_names_fun}{[\code{function}]\cr a function to clean column names, e.g. \link{tolower}, \code{\link[janitor:clean_names]{janitor::clean_names()}},...}

\item{split_mixed}{[\code{logical(1): FALSE}]\cr whether to split mixed datasets. See \link{split_mixed_datasets}.}

\item{extend_lookup}{[\code{character(1): FALSE}]\cr whether to enrich the lookup table. See \link{extend_lookup}.}

\item{datetime_extraction}{[\code{POSIXt(1)}]\cr the datetime of the data extraction. Default to the most common date of last modification in \code{directory}.}

\item{verbose}{[\code{logical(1)}]\cr one of \code{c(0, 1, 2)}. The higher, the more information will be printed.}

\item{key_columns}{deprecated}
}
\value{
a list containing one dataframe for each \code{.xpt} file in the folder, the extraction date (\code{datetime_extraction}), and a summary of all imported tables (\code{.lookup}). If not set yet, option \code{edc_lookup} is automatically set to \code{.lookup}.
}
\description{
Read all \code{.xpt} files in a directory (unzipped TrialMaster archive). \cr
If \verb{7zip} is installed, you should probably rather use \code{\link[=read_trialmaster]{read_trialmaster()}} instead. \cr
If a \code{procformat.sas} file exists in the directory, formats will be applied.
}
