# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculates DysPIA statistic values for the gene pair sets
#'
#' @name calcDyspiaStatCumulativeBatch
#' @param stats Named numeric vector with gene pair-level statistics 
#'        sorted in decreasing order (order is not checked).
#' @param DyspiaParam DysPIA weight parameter (0 is unweighted, suggested value is 1).
#' @param pathwayScores Vector with enrichment scores for the pathways in the database.
#' @param pathwaysSizes Vector of pathway sizes.
#' @param iterations Number of iterations.
#' @param seed Seed vector
#' @return List of DysPIA statistics for gene pair sets.
#' @export
calcDyspiaStatCumulativeBatch <- function(stats, DyspiaParam, pathwayScores, pathwaysSizes, iterations, seed) {
    .Call(`_DysPIA_calcDyspiaStatCumulativeBatch`, stats, DyspiaParam, pathwayScores, pathwaysSizes, iterations, seed)
}

#' Calculates DysPIA statistic values for all the prefixes of a gene pair set
#'
#' @name calcDyspiaStatCumulative
#' @param stats Named numeric vector with gene pair-level statistics
#'        sorted in decreasing order (order is not checked)
#' @param selectedStats indexes of selected gene pairs in a `stats` array
#' @param DyspiaParam DysPIA weight parameter (0 is unweighted, suggested value is 1)
#' @return Numeric vector of DysPIA statistics for all prefixes of selectedStats.
#' @export
calcDyspiaStatCumulative <- function(stats, selectedStats, DyspiaParam) {
    .Call(`_DysPIA_calcDyspiaStatCumulative`, stats, selectedStats, DyspiaParam)
}

