% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H_optimalSeq.R
\name{optimalSeq}
\alias{optimalSeq}
\title{Missing or Coarsened Data Perspective - Genetic Algorithm}
\usage{
optimalSeq(..., moPropen, moMain, moCont, data, response, txName, regimes,
  fSet = NULL, refit = FALSE, iter = 0L, verbose = TRUE)
}
\arguments{
\item{...}{Additional arguments required by rgenoud. At a minimum this
should include Domains, pop.size and starting.values.
See ?rgenoud for more information.}

\item{moPropen}{An object of class modelObj, a list of objects of class
modelObj, or a list of object of class modelObjSubset,
which define the models and R methods to be used to obtain
parameter estimates and predictions for the propensity for
treatment.
See ?moPropen for details.}

\item{moMain}{An object of class modelObj, a list of objects of class
modelObj, or a list of object of class modelObjSubset,
which define the models and R methods to be used to obtain
parameter estimates and predictions for the main effects
component of the outcome regression.
See ?modelObj and/or ?modelObjSubset for details.
NULL is an acceptable input if IPWE is desired or there is
no main effects component of the outcome regression model.}

\item{moCont}{An object of class modelObj, a list of objects of class
modelObj, or a list of object of class modelObjSubset,
which define the models and R methods to be used to obtain
parameter estimates and predictions for the contrasts
component of the outcome regression.
See ?modelObj and/or ?modelObjSubset for details.
NULL is an acceptable input if IPWE is desired or there is
no contrast component of the outcome regression model.}

\item{data}{A data frame of the covariates and tx history}

\item{response}{The response vector}

\item{txName}{A vector of characters.
The column headers of \emph{data} that correspond to the tx
covariate for each decision point.
The ordering should be sequential, i.e., the 1st element
gives column name for the 1st decision point tx, the
2nd gives column name for the 2nd decision point tx,
etc.}

\item{regimes}{A function or a list of functions.
For each decision point, a function defining the tx
rule. For example, if the tx rule is : I(eta_1 < x1),
regimes is defined as
regimes <- function(a,data) \{as.numeric(a < data$x1)\}
THE LAST ARGUMENT IS ALWAYS TAKEN TO BE THE DATA.FRAME}

\item{fSet}{A function or a list of functions.
This argument allows the user to specify the subset of tx
options available to a patient or the subset of patients
that will be modeled uniquely.
see ?fSet for details}

\item{refit}{No longer used}

\item{iter}{An integer. See ?iter for details}

\item{verbose}{A logical. If FALSE, screen prints are suppressed.}
}
\value{
An object inheriting from class OptimalSeq
}
\description{
Missing or Coarsened Data Perspective - Genetic Algorithm
}
\examples{

# Load and process data set
data(bmiData)

# define the negative 12 month change in BMI from baseline
y12 <- -100*(bmiData[,6L] - bmiData[,4L])/bmiData[,4L]

# Define the propensity for treatment model and methods.
# Will use constant model for both decision points
moPropen <- buildModelObj(model =  ~ 1, 
                          solver.method = 'glm', 
                          solver.args = list('family'='binomial'),
                          predict.method = 'predict.glm',
                          predict.args = list(type='response'))
moPropen <- list(moPropen, moPropen)

# outcome model second stage
moMain2 <- buildModelObj(model = ~parentBMI+month4BMI,
                         solver.method = 'lm')

moCont2 <- buildModelObj(model = ~race + parentBMI+month4BMI,
                         solver.method = 'lm')

# outcome model first stage
moMain1 <- buildModelObj(model = ~parentBMI+baselineBMI,
                         solver.method = 'lm')

moCont1 <- buildModelObj(model = ~race + parentBMI+baselineBMI,
                         solver.method = 'lm')

moMain <- list(moMain1, moMain2)
moCont <- list(moCont1, moCont2)

# regime function second stage
regime2 <- function(eta1, eta2, data) {
             tst <- {data$parentBMI > eta1} & {data$month4BMI > eta2}
             rec <- rep('MR', nrow(x = data))
             rec[!tst] <- 'CD'
             return( rec )
           }

# regime function first stage
regime1 <- function(eta1, eta2, data) {
             tst <- {data$parentBMI > eta1} & {data$baselineBMI > eta2}
             rec <- rep('MR', nrow(x = data))
             rec[!tst] <- 'CD'
             return( rec )
           }

regimes <- list(regime1, regime2)

#### Analysis using AIPW
\dontrun{
fit_AIPW <- optimalSeq(moPropen = moPropen, 
                       moMain = moMain, moCont = moCont,
                       regimes = regimes,
                       data = bmiData, response = y12,  txName = c('A1','A2'),
                       Domains = cbind(rep(0,4),rep(100,4)),
                       pop.size = 100, starting.values = rep(25,4))

##Available methods

  # Coefficients of the regression objects
  coef(object = fit_AIPW)

  # Description of method used to obtain object
  DTRstep(object = fit_AIPW)

  # Estimated value of the optimal treatment regime for training set
  estimator(x = fit_AIPW)

  # Value object returned by regression methods
  fitObject(object = fit_AIPW)

  # Retrieve the results of genetic algorithm
  genetic(object = fit_AIPW)

  # Estimated optimal treatment and decision functions for training data
  optTx(x = fit_AIPW)

  # Estimated optimal treatment and decision functions for new data
  optTx(x = fit_AIPW, newdata = bmiData)

  # Value object returned by outcome regression method
  outcome(object = fit_AIPW)

  # Plots if defined by regression methods
  dev.new()
  par(mfrow = c(2,4))

  plot(x = fit_AIPW)
  plot(x = fit_AIPW, suppress = TRUE)

  # Retrieve the value object returned by propensity regression method
  propen(object = fit_AIPW)

  # Show main results of method
  show(object = fit_AIPW)

  # Show summary results of method
  summary(object = fit_AIPW)
}
#### Single Decision Point Analysis using IPW

# Define the propensity for treatment model and methods.
moPropen <- buildModelObj(model =  ~ 1, 
                          solver.method = 'glm', 
                          solver.args = list('family'='binomial'),
                          predict.method = 'predict.glm',
                          predict.args = list(type='response'))

# regime function second stage
regime <- function(eta1, eta2, data) {
            tst <- {data$parentBMI > eta1} & {data$month4BMI > eta2}
            rec <- rep('MR', nrow(x = data))
            rec[!tst] <- 'CD'
            return( rec )
          }
\dontrun{
fit_IPW <- optimalSeq(moPropen = moPropen, 
                      regimes = regime,
                      data = bmiData, response = y12,  txName = 'A2',
                      Domains = cbind(rep(0,2),rep(100,2)),
                      pop.size = 100, starting.values = rep(25,2))

##Available methods

  # Coefficients of the regression objects
  coef(object = fit_IPW)

  # Description of method used to obtain object
  DTRstep(object = fit_IPW)

  # Estimated value of the optimal treatment regime for training set
  estimator(x = fit_IPW)

  # Value object returned by regression method
  fitObject(object = fit_IPW)

  # Retrieve the results of genetic algorithm
  genetic(object = fit_IPW)

  # Estimated optimal treatment and decision functions for training data
  optTx(x = fit_IPW)

  # Estimated optimal treatment and decision functions for new data
  optTx(x = fit_IPW, newdata = bmiData)

  # Value object returned by outcome regression method
  outcome(object = fit_IPW)

  # Plots if defined by outcome regression method
  dev.new()
  par(mfrow = c(2,4))

  plot(x = fit_IPW)
  plot(x = fit_IPW, suppress = TRUE)

  # Retrieve the value object returned by propensity regression method
  propen(object = fit_IPW)

  # Show main results of method
  show(object = fit_IPW)

  # Show summary results of method
  summary(object = fit_IPW)
}
}
\references{
Baqun Zhang, Anastasios A. Tsiatis, Eric B. Laber & Marie Davidian,
  "A Robust Method for Estimating Optimal Treatment Regimes",
  Biometrics, 68, 1010-1018.

Baqun Zhang, Anastasios A. Tsiatis, Eric B. Laber & Marie Davidian,
  "Robust estimation of optimal treatment regimes for sequential
  treatment decisions", Biometrika (2013) pp.1-14.
}
\seealso{
Other statistical methods: \code{\link{bowl}},
  \code{\link{earl}}, \code{\link{iqLearn}},
  \code{\link{optimalClass}}, \code{\link{owl}},
  \code{\link{qLearn}}, \code{\link{rwl}}

Other single decision point methods: \code{\link{earl}},
  \code{\link{optimalClass}}, \code{\link{owl}},
  \code{\link{qLearn}}, \code{\link{rwl}}

Other multiple decision point methods: \code{\link{bowl}},
  \code{\link{iqLearn}}, \code{\link{optimalClass}},
  \code{\link{qLearn}}
}
\concept{multiple decision point methods}
\concept{single decision point methods}
\concept{statistical methods}
