% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtHist.R
\name{rtHist}
\alias{rtHist}
\title{Make histograms of reaction time data}
\usage{
rtHist(data, what = "cr", layout = NULL, nms = NULL, ggplot = FALSE,
  ...)
}
\arguments{
\item{data}{A reaction time dataset. Must be a dataframe with $rt, $condition
and $response.}

\item{what}{@param what What to plot. Can be 'cr' for 'condition-response pairs,
'c' for condition, and 'r' for response.}

\item{layout}{An optional layout.}

\item{nms}{An optional vector of names for each plot. If omitted the names
will be based on the contents of \code{data$condition} and/or \code{data$response}.}

\item{ggplot}{ggplot Logical, should ggplot2 be used instead of base R graphics? If set to TRUE,
some arguments from \code{linesArgs} and \code{...} will be ignored (but can be added
to plots manually).}

\item{...}{Arguments to be passed to \code{hist}}
}
\value{
invisible()
}
\description{
Make histograms of reaction time data
}
\details{
This function and \code{\link{rtDescriptives}} are helper functions to inspect raw data.
}
\examples{
tt = seq(0, 5, .01)
dat = simData(n = 3e4, pars = rep(.5, 5), tt = tt, pdfND = dbeta(tt, 10, 30))
rtHist(dat, breaks = tt, xlim = c(0, 1))
}
