% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estQdf.R
\name{estQdf}
\alias{estQdf}
\title{Estimate quantiles of distribution}
\usage{
estQdf(p, x, cdf)
}
\arguments{
\item{p}{A vector of probabilities.}

\item{x}{The x-axis values corresponding to the cumulative distribution function.}

\item{cdf}{A cumulative distributions function, i.e. output of \code{\link{estCdf}}.}
}
\value{
Quantiles of cumulative distribution function(s). If the input was a matrix
of cumulative distributions functions, a matrix of quantiles is returned.
}
\description{
Estimate quantiles of distribution
}
\details{
Quantiles are obtained in the following manner. For p = 0 and p = 1,
the minimum and maximum of x is used. For other probabilities the quantiles are obtained
via \code{q[i] = uniroot(x, cdf - p[i])$root}. Y values are interpolated via
\code{\link{approxfun}}.
}
\examples{
x = seq(-9, 9, .1) # x-grid
d = dnorm(x) # density functions
p = seq(0, 1, .2) # probabilities of interest
cEst = estCdf(d) # estimate cumulative distribution functions
qEst = estQdf(p = p, x = x, cdf = cEst) # estimate quantiles
plot(x, cEst, bty = 'n', las = 1, type = 'l', ylab = 'Probability') # plot cdf
abline(h = p, v = qEst, col = 1:6, lty = 2) # add lines for p and for obtained quantiles
points(x = qEst, y = p, pch = 18, col = 1:6, cex = 1.75) # add points for intersections

}

