% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/KuiperTestStat.R
\name{KuiperTestStat}
\alias{KuiperTestStat}
\title{Plots cummulative density for Kuiper test and computes confidence interval
for Kuiper test stat.}
\usage{
KuiperTestStat(number.trials, sample.size, confidence.interval)
}
\arguments{
\item{number.trials}{Number of trials}

\item{sample.size}{Sizes of the trial samples}

\item{confidence.interval}{Confidence interval expressed as a fraction of 1}
}
\value{
Confidence Interval for KS test stat
}
\description{
Kuiper test statistic is a non parametric test for
distribution equality and is closely related to KS test. Formally, the
Kuiper test statistic is :
 \deqn{D*=\max_i\{F(X_i)-\hat{F(x_i)}+\max_i\{\hat{F}(X_i)-F(X_i)\}}
}
\examples{
# Plots the cdf for Kuiper Test statistic and returns Kuiper confidence
   # interval for 100 trials with 1000 sample size and 0.95 confidence
   # interval.
   KuiperTestStat(100, 1000, 0.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

