% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{conv}
\alias{conv}
\alias{norm2}
\alias{normalize}
\alias{to_cir}
\alias{to_rad}
\alias{to_sph}
\title{Convenience functions}
\usage{
norm2(x)

normalize(x)

to_cir(th)

to_rad(x)

to_sph(th, ph)
}
\arguments{
\item{x}{matrix or vector, in \eqn{S^1} for \code{to_cir}.}

\item{th}{vector of angles in \eqn{[0, 2\pi)}.}

\item{ph}{vector of angles in \eqn{[0, \pi]}.}
}
\value{
Euclidean norm (\code{norm}) and normalized data (\code{normalize}).
Position in \eqn{S^1} (\code{to_cir}) or in \eqn{[0, 2\pi)} (\code{to_rad}).
Position in \eqn{S^2} (\code{to_sph}) or in \eqn{[0, 2\pi) \times [0, \pi]}
(\code{to_rad}).
}
\description{
Normalization of data in \eqn{R^{q + 1}} to \eqn{S^q}.
Transformations between \eqn{S^1} and \eqn{[0, 2\pi)}, and between
\eqn{S^2} and \eqn{[0, 2\pi) \times [0, \pi]}.
}
\examples{
# Normalization
x <- 1:3
norm2(x)
normalize(x)
x <- rbind(1:3, 3:1)
norm2(x)
normalize(x)

# Circular transformations
th <- 1
x <- c(0, 1)
to_rad(to_cir(th))
to_rad(to_cir(c(th, th + 1)))
to_cir(to_rad(x))
to_cir(to_rad(rbind(x, -x)))

# Spherical transformations
th <- 2
ph <- 1
x <- c(0, 1, 0)
to_rad(to_sph(th, ph))
to_rad(to_sph(c(th, th + 1),
              c(ph, ph + 1)))
to_sph(to_rad(x)[, 1], to_rad(x)[, 2])
to_sph(to_rad(rbind(x, -x))[, 1], to_rad(rbind(x, -x))[, 2])
}
