% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_reverse_edges_ws.R
\name{add_reverse_edges_ws}
\alias{add_reverse_edges_ws}
\title{Add new edges in the opposite directions of a selection of edges}
\usage{
add_reverse_edges_ws(graph, rel = NULL, edge_aes = NULL, edge_data = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{rel}{An optional string to apply a \code{rel} attribute to all newly created
edges.}

\item{edge_aes}{An optional list of named vectors comprising edge aesthetic
attributes. The helper function \code{\link[=edge_aes]{edge_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted edge aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{penwidth}, \code{color}).}

\item{edge_data}{An optional list of named vectors comprising edge data
attributes. The helper function \code{\link[=edge_data]{edge_data()}} is strongly recommended for
use here as it helps bind data specifically to the created edges.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Add edges in the opposite direction of one or more edges available as an edge
selection in a graph object of class \code{dgr_graph}. New graph edges have the
opposite edge definitions as those in the selection. For example, a graph
with the edge \code{1->2} in its active selection will gain a new \code{2->1} edge.
There is also the option to assign a common \code{rel} grouping to the newly
created edges. Upon addition of the edges, the edge selection will be
retained for further selection or traversal operations.
}
\details{
This function makes use of an active selection of edges (and the function
ending with \verb{_ws} hints at this).

Selections of edges can be performed using the following selection
(\verb{select_*()}) functions: \code{\link[=select_edges]{select_edges()}}, \code{\link[=select_last_edges_created]{select_last_edges_created()}},
\code{\link[=select_edges_by_edge_id]{select_edges_by_edge_id()}}, or \code{\link[=select_edges_by_node_id]{select_edges_by_node_id()}}.

Selections of edges can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out_edge]{trav_out_edge()}}, \code{\link[=trav_in_edge]{trav_in_edge()}},
\code{\link[=trav_both_edge]{trav_both_edge()}}, or \code{\link[=trav_reverse_edge]{trav_reverse_edge()}}.
}
\examples{
# Create an empty graph, add 2 nodes to it,
# and create the edge `1->2`
graph <-
  create_graph() \%>\%
  add_n_nodes(
    n = 2,
    type = "type_a",
    label = c("a_1", "a_2")) \%>\%
  add_edge(
    from = 1,
    to = 2,
    rel = "a")

# Get the graph's edges
graph \%>\% get_edge_ids()

# Select the edge and create 2 additional edges
# with the opposite definition of `1->2`, which
# is `2->1`; also, apply, different `rel` values
# (`b` and `c`)
graph <-
  graph \%>\%
  select_edges() \%>\%
  add_reverse_edges_ws(rel = "b") \%>\%
  add_reverse_edges_ws(rel = "c") \%>\%
  clear_selection()

# Get the graph's edge data frame
graph \%>\% get_edge_df()

}
\seealso{
Other Edge creation and removal: 
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_edge}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_edge}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{rev_edge_dir}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs_ws}()},
\code{\link{set_edge_attrs}()}
}
\concept{Edge creation and removal}
