% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_nodes_ws.R
\name{delete_nodes_ws}
\alias{delete_nodes_ws}
\title{Delete all nodes in a node selection}
\usage{
delete_nodes_ws(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
In a graph object of class \code{dgr_graph}, delete all nodes present in a
selection of nodes.
}
\details{
This function makes use of an active selection of nodes (and the function
ending with \verb{_ws} hints at this).

Selections of nodes can be performed using the following node selection
(\verb{select_*()}) functions: \code{\link[=select_nodes]{select_nodes()}}, \code{\link[=select_last_nodes_created]{select_last_nodes_created()}},
\code{\link[=select_nodes_by_degree]{select_nodes_by_degree()}}, \code{\link[=select_nodes_by_id]{select_nodes_by_id()}}, or
\code{\link[=select_nodes_in_neighborhood]{select_nodes_in_neighborhood()}}.

Selections of nodes can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out]{trav_out()}}, \code{\link[=trav_in]{trav_in()}}, \code{\link[=trav_both]{trav_both()}},
\code{\link[=trav_out_node]{trav_out_node()}}, \code{\link[=trav_in_node]{trav_in_node()}}, \code{\link[=trav_out_until]{trav_out_until()}}, or
\code{\link[=trav_in_until]{trav_in_until()}}.
}
\examples{
# Create a graph with 3 nodes
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 3) \%>\%
  add_edges_w_string(
    edges = "1->3 1->2 2->3")

# Select node with ID `1`
graph <-
  graph \%>\%
  select_nodes_by_id(nodes = 1)

# Delete node in selection (this
# also deletes any attached edges)
graph <-
  graph \%>\%
  delete_nodes_ws()

# Get a count of nodes in the graph
graph \%>\% count_nodes()

}
