% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_closeness.R
\name{get_closeness}
\alias{get_closeness}
\title{Get closeness centrality values}
\usage{
get_closeness(graph, direction = "all")
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{direction}{using \code{all} (the default), the search will ignore edge
direction while traversing through the graph. With \code{out}, measurements
of paths will be from a node whereas with \verb{in}, measurements of paths
will be to a node.}
}
\value{
A data frame with closeness values for each of the nodes.
}
\description{
Get the closeness centrality values for all nodes in a graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 10,
    m = 12,
    set_seed = 23)

# Get closeness values for all nodes
# in the graph
graph \%>\% get_closeness()

# Add the closeness values to
# the graph as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_closeness(.))

# Display the graph's node data frame
graph \%>\% get_node_df()

}
