% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_forward_edges_ws.R
\name{add_forward_edges_ws}
\alias{add_forward_edges_ws}
\title{Add new edges with identical definitions as with a
selection of edges}
\usage{
add_forward_edges_ws(graph, rel = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{rel}{an optional string to apply a
\code{rel} attribute to all newly created edges.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Add edges in the same direction
of one or more edges available as an edge selection
in a graph object of class \code{dgr_graph}. New
graph edges have the same edge definitions as those
in the selection except with new edge ID values.
There is also the option to assign a common
\code{rel} grouping to the newly created edges.
Upon addition of the edges, the edge selection will
be retained for further selection or traversal
operations.

Selections of edges can be performed using
the following \code{select_...} functions:
\code{select_edges()},
\code{select_last_edge()}, or
\code{select_edges_by_node_id()}.
Selections of edges can also be performed using
the following traversal functions:
\code{trav_out_edge()}, \code{trav_in_edge()},
or \code{trav_both_edge()}.
}
\examples{
# Create an empty graph, add 2 nodes to it,
# and create the edge `1->2`
graph <-
  create_graph() \%>\%
  add_n_nodes(
    n = 2,
    type = "type_a",
    label = c("a_1", "a_2")) \%>\%
  add_edge(
    from = 1, to = 2, rel = "a")

# Get the graph's edges
graph \%>\%
  get_edge_ids()

# Select the edge and create 2 additional edges
# with the same definition (`1->2`) but with
# different `rel` values (`b` and `c`)
graph <-
  graph \%>\%
  select_edges() \%>\%
  add_forward_edges_ws(rel = "b") \%>\%
  add_forward_edges_ws(rel = "c") \%>\%
  clear_selection()

# Get the graph's edge data frame
graph \%>\%
  get_edge_df()
}
