% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_radiality.R
\name{get_radiality}
\alias{get_radiality}
\title{Get radiality centrality scores}
\usage{
get_radiality(graph, direction = "all")
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{direction}{using \code{all} (the default), the
search will ignore edge direction while traversing
through the graph. With \code{out}, measurements of
paths will be from a node whereas with \code{in},
measurements of paths will be to a node.}
}
\value{
a data frame with radiality centrality
scores for each of the nodes.
}
\description{
Get the radiality centrality
for all nodes in a graph. These scores describe
the ease to which nodes can reach other nodes.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the radiality scores for nodes in the graph
get_radiality(graph)
#>    id radiality
#> 1   1  2.888889
#> 2   2  2.888889
#> 3   3  2.888889
#> 4   4  2.666667
#> 5   5  3.000000
#> 6   6  3.222222
#> 7   7  2.777778
#> 8   8  2.555556
#> 9   9  3.000000
#> 10 10  3.000000

# Add the radiality values to the graph
# as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_radiality(.))

# Display the graph's node data frame
get_node_df(graph)
#>    id type label value radiality
#> 1   1 <NA>     1   6.0  2.888889
#> 2   2 <NA>     2   2.5  2.888889
#> 3   3 <NA>     3   3.5  2.888889
#> 4   4 <NA>     4   7.5  2.666667
#> 5   5 <NA>     5   8.5  3.000000
#> 6   6 <NA>     6   4.5  3.222222
#> 7   7 <NA>     7  10.0  2.777778
#> 8   8 <NA>     8  10.0  2.555556
#> 9   9 <NA>     9   8.5  3.000000
#> 10 10 <NA>    10  10.0  3.000000
}
