% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_authority_centrality.R
\name{get_authority_centrality}
\alias{get_authority_centrality}
\title{Get the authority scores for nodes in the graph}
\usage{
get_authority_centrality(graph, weights_attr = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{weights_attr}{an optional name of the edge
attribute to use in the adjacency matrix. If
\code{NULL} then, if it exists, the \code{weight}
edge attribute of the graph will be used.}
}
\value{
a data frame with authority scores for
each of the nodes.
}
\description{
Get the Kleinberg authority centrality
scores for all nodes in the graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the authority centrality scores
# for all nodes in the graph
get_authority_centrality(graph)
#>    id authority_centrality
#> 1   1            0.0000000
#> 2   2            0.0000000
#> 3   3            0.3237777
#> 4   4            0.0000000
#> 5   5            0.8083310
#> 6   6            0.8593282
#> 7   7            0.7895083
#> 8   8            0.4482946
#> 9   9            0.8023324
#> 10 10            1.0000000
}
