% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_balanced_tree.R
\name{add_balanced_tree}
\alias{add_balanced_tree}
\title{Add a balanced tree to the graph}
\usage{
add_balanced_tree(graph, k, h, type = NULL, label = TRUE, rel = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{k}{the branching factor for the tree.}

\item{h}{the height of the tree.}

\item{type}{an optional string that describes the
entity type for the nodes to be added.}

\item{label}{either a vector object of length
\code{n} that provides optional labels for the new
nodes, or, a boolean value where setting to
\code{TRUE} ascribes node IDs to the label and
\code{FALSE} yields a blank label.}

\item{rel}{an optional string for providing a
relationship label to all new edges created in the
node tree.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class
\code{dgr_graph}, add a balanced tree to the graph.
}
\examples{
# Create a new graph and add 2 different types of
# balanced trees of height 2 (branching twice) and
# different branching ratios
graph <-
  create_graph() \%>\%
  add_balanced_tree(
    k = 2,
    h = 2,
    type = "binary") \%>\%
  add_balanced_tree(
    k = 3,
    h = 2,
    type = "tertiary")

# Get some node information from this graph
node_info(graph) \%>\%
  head(5)
#>   id   type label deg indeg outdeg loops
#> 1  1 binary     1   2     0      2     0
#> 2  2 binary     2   3     1      2     0
#> 3  3 binary     3   3     1      2     0
#> 4  4 binary     4   1     1      0     0
#> 5  5 binary     5   1     1      0     0
}
