% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_edges_by_node_id.R
\name{select_edges_by_node_id}
\alias{select_edges_by_node_id}
\title{Select edges in a graph using node ID values}
\usage{
select_edges_by_node_id(graph, nodes, set_op = "union")
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{nodes}{a vector of node IDs for the selection
of edges present in the graph.}

\item{set_op}{the set operation to perform upon
consecutive selections of graph edges This can
either be as a \code{union} (the default), as an
intersection of selections with \code{intersect},
or, as a \code{difference} on the previous
selection, if it exists.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Select edges in a graph object of class
\code{dgr_graph} using node ID values. All edges
associated with the provided nodes will be included
in the selection.
}
\examples{
# Create a graph with 5 nodes
graph <-
  create_graph() \%>\%
  add_path(5)

# Create a graph selection by selecting edges
# associated with nodes `1` and `2`
graph <-
  graph \%>\%
  select_edges_by_node_id(1:2)

# Get the selection of edges
graph \%>\% get_selection()
#> [1] 1 2

# Perform another selection of edges, with nodes
# `1`, `2`, and `4`
graph <-
  graph \%>\%
  clear_selection() \%>\%
  select_edges_by_node_id(c(1, 2, 4))

# Get the selection of edges
graph \%>\% get_selection
#> [1] 1 2 3 4

# Get a fraction of the edges selected over all
# the edges in the graph
graph \%>\%
{
  l <- get_selection(.) \%>\%
    length(.)
  e <- edge_count(.)
  l/e
}
#> [1] 1
}

