% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_path.R
\name{add_path}
\alias{add_path}
\title{Add a path of nodes to the graph}
\usage{
add_path(graph, n, type = NULL, label = TRUE, rel = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{n}{the number of nodes comprising the path.}

\item{type}{an optional string that describes the
entity type for the nodes to be added.}

\item{label}{either a vector object of length
\code{n} that provides optional labels for the new
nodes, or, a boolean value where setting to
\code{TRUE} ascribes node IDs to the label and
\code{FALSE} yields a blank label.}

\item{rel}{an optional string for providing a
relationship label to all new edges created in the
node path.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class
\code{dgr_graph}, add a node path to the graph.
}
\examples{
# Create a new graph and add 2 paths of varying
# lengths
graph <-
  create_graph() \%>\%
  add_path(4, "four_path") \%>\%
  add_path(5, "five_path")

# Get node information from this graph
node_info(graph)
#>   id      type label deg indeg outdeg loops
#> 1  1 four_path     1   1     0      1     0
#> 2  2 four_path     2   2     1      1     0
#> 3  3 four_path     3   2     1      1     0
#> 4  4 four_path     4   1     1      0     0
#> 5  5 five_path     1   1     0      1     0
#> 6  6 five_path     2   2     1      1     0
#> 7  7 five_path     3   2     1      1     0
#> 8  8 five_path     4   2     1      1     0
#> 9  9 five_path     5   1     1      0     0
}

