% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_degree_distribution.R
\name{get_degree_distribution}
\alias{get_degree_distribution}
\title{Get degree distribution data for a graph}
\usage{
get_degree_distribution(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a named vector of degree frequencies
where the degree values serve as names.
}
\description{
Get degree distribution data for
a graph. Graph degree is represented as a
frequency of degree values over all nodes in
the graph.
}
\examples{
# Create a random, directed graph with 18 nodes
# and 22 edges
graph <-
  create_random_graph(
    n = 18, m = 22,
    set_seed = 23)

# Get degree distribution data for `random_graph`
graph \%>\% get_degree_distribution()
#> 0          1          2          3
#> 0.05555556 0.22222222 0.22222222 0.22222222
#> 4
#> 0.27777778
}

