% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_node_attrs.R
\name{drop_node_attrs}
\alias{drop_node_attrs}
\title{Drop a node attribute column}
\usage{
drop_node_attrs(graph, node_attr)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node_attr}{the name of the node attribute
column to drop.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
Within a graph's internal NDF, remove
an existing node attribute.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    5, 10, set_seed = 3)

# Get the graph's internal ndf to show
# which node attributes are available
get_node_df(graph)
#>   id type label value
#> 1  1 <NA>     1   2.0
#> 2  2 <NA>     2   8.5
#> 3  3 <NA>     3   4.0
#> 4  4 <NA>     4   3.5
#> 5  5 <NA>     5   6.5

# Drop the `value` node attribute
graph <-
  graph \%>\%
  drop_node_attrs("value")

# Get the graph's internal ndf to show that
# the node attribute `value` had been removed
get_node_df(graph)
#>   id type label
#> 1  1 <NA>     1
#> 2  2 <NA>     2
#> 3  3 <NA>     3
#> 4  4 <NA>     4
#> 5  5 <NA>     5
}

