% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n_nodes.R
\name{add_n_nodes}
\alias{add_n_nodes}
\title{Add one or several unconnected nodes to the graph}
\usage{
add_n_nodes(graph, n, set_node_type = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{n}{the number of new nodes to add to the graph.}

\item{set_node_type}{an optional string to apply a
\code{type} attribute to all newly created nodes.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Add n new nodes to a graph object of
class \code{dgr_graph}. Optionally, set node
\code{type} values for the new nodes.
}
\examples{
library(magrittr)

# Create an empty graph and add 5 nodes to it; these
# nodes will be given ID values from 1 to 5
graph <-
  create_graph() \%>\%
  add_n_nodes(5)

# Get the graph's nodes
graph \%>\% get_nodes
#> [1] "1" "2" "3" "4" "5"
}

