% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSCo_CI.R
\name{DiSCo_CI_iter}
\alias{DiSCo_CI_iter}
\title{DiSCo_CI_iter}
\usage{
DiSCo_CI_iter(
  redraw,
  controls,
  weights,
  cl = 0.95,
  evgrid = seq(from = 0, to = 1, length.out = 1001),
  qmethod = NULL
)
}
\arguments{
\item{redraw}{Integer indicating the number of times the function has been called}

\item{controls}{List of control units}

\item{weights}{Vector of optimal synthetic control weights, computed using the DiSCo_weights_reg function.}

\item{cl}{Numeric, confidence level for the (two-sided) confidence intervals.}

\item{qmethod}{Character, indicating the method to use for computing the quantiles of the target distribution. The default is NULL, which uses the \code{\link[stats]{quantile}} function from the stats package.
Other options are "\code{\link[evmix]{qkden}}" (based on smoothed kernel density function) and "\code{\link[extremeStat:distLquantile]{extreme}}" (based on parametric extreme value distributions).
Both are substantially slower than the default method but may be useful for fat-tailed distributions with few data points at the upper quantiles. Alternatively, one could use the q_max option to restrict the range of quantiles used.}
}
\value{
The resampled counterfactual barycenter of the target unit
}
\description{
Function for computing the confidence intervals in the DiSCo method in a single period
}
\keyword{internal}
