% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_factorial_designer.R
\name{simple_factorial_designer}
\alias{simple_factorial_designer}
\title{Create a simple factorial design}
\usage{
simple_factorial_designer(N = 100, prob_A = 0.5, prob_B = 0.5,
  weight_A = 0.5, weight_B = 0.5, outcome_means = rep(0, 4),
  mean_A0B0 = outcome_means[1], mean_A0B1 = outcome_means[2],
  mean_A1B0 = outcome_means[3], mean_A1B1 = outcome_means[4],
  sd_i = 1, outcome_sds = rep(0, 4))
}
\arguments{
\item{N}{An integer. Size of sample.}

\item{prob_A}{A number in [0,1]. Probability of assignment to treatment A.}

\item{prob_B}{A number in [0,1]. Probability of assignment to treatment B.}

\item{weight_A}{A number. Weight placed on A=1 condition in definition of "average effect of B" estimand.}

\item{weight_B}{A number. Weight placed on B=1 condition in definition of "average effect of A" estimand.}

\item{outcome_means}{A vector of length 4. Average outcome in each A,B condition, in order AB = 00, 01, 10, 11. Values overridden by mean_A0B0, mean_A0B1, mean_A1B0, if provided mean_A1B1.}

\item{mean_A0B0}{A number. Mean outcome in A=0, B=0 condition.}

\item{mean_A0B1}{A number. Mean outcome in A=0, B=1 condition.}

\item{mean_A1B0}{A number. Mean outcome in A=1, B=0 condition.}

\item{mean_A1B1}{A number. Mean outcome in A=1, B=1 condition.}

\item{sd_i}{A nonnegative scalar. Standard deviation of individual-level shock (common across arms).}

\item{outcome_sds}{A nonnegative vector of length 4. Standard deviation of (additional) unit level shock in each condition, in order AB = 00, 01, 10, 11.}
}
\value{
A two-by-two factorial design.
}
\description{
Builds a two-by-two factorial design in which assignments to each factor are independent of each other.
}
\details{
Three types of estimand are declared. First, weighted averages of the average treatment effects of each treatment, given the two conditions of the other treatments. Second and third, the difference in treatment effects of each treatment, given the conditions of the other treatment.

Units are assigned to treatment using complete random assignment. Potential outcomes follow a normal distribution.

Treatment A is assigned first and then Treatment B within blocks defined by treatment A. Thus, if there are 6 units 
3 are guaranteed to receive treatment A but the number receiving treatment B is stochastic.

See \code{\link{multi_arm_designer}} for a factorial design with non independent assignments.
}
\examples{
design <- simple_factorial_designer(outcome_means = c(0,0,0,1))

# A design biased for the specified estimands:
design <- simple_factorial_designer(outcome_means = c(0,0,0,1), prob_A = .8, prob_B = .2)
\dontrun{
diagnose_design(design)
}

# A design with estimands that "match" the assignment:
design <- simple_factorial_designer(outcome_means = c(0,0,0,1), 
                                    prob_A = .8, prob_B = .2, 
                                    weight_A = .8, weight_B = .2)
\dontrun{
diagnose_design(design)
}

# Compare power with and without interactions, given same average effects in each arm
designs <- redesign(simple_factorial_designer(), 
                    outcome_means = list(c(0,0,0,1), c(0,.5,.5,1)))
\dontrun{
diagnose_design(designs)
}

}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{experiment factorial}
