% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{deprects}
\alias{deprects}
\title{Rectangles of averaged colors}
\usage{
deprects(part, yoff, ic.scale = TRUE)
}
\arguments{
\item{part}{the set of sequences as \link{DLData} object}

\item{yoff}{the offset in y-direction within the current plot}

\item{ic.scale}{if \code{TRUE}, alpha values of colors will be assigned based on "information content" of the distribution at each position}
}
\value{
the vertical (y) offset after this plot
}
\description{
Plot a representation of a set of sequences by rectangles of (scaled) averaged color values of the symbols at each position.
}
\details{
This function is a low-level plotting function (using \link[graphics]{rect}, internally).
}
\examples{
# read data and create DLData object
seqs <- read.table(system.file("extdata", "cjun.txt", package = "DepLogo"),  
   stringsAsFactors = FALSE)
data <- DLData(sequences = seqs[, 1],weights = log1p(seqs[, 2]) )

# create high-level plot
plot(NULL, xlim = c(1, ncol(data$data) - 1), ylim = c(0, nrow(data$data)), 
    ylab = nrow(data$data), axes = FALSE)
# and add deprects and axis
deprects(data, yoff = nrow(data$data))
axis(1)
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
