% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_neural.R
\name{pattc_deepneural}
\alias{pattc_deepneural}
\title{Estimate PATT_C using Deep NN}
\usage{
pattc_deepneural(
  response.formula,
  exp.data,
  pop.data,
  treat.var,
  compl.var,
  compl.algorithm = "rprop+",
  response.algorithm = "rprop+",
  compl.hidden.layer = c(4, 2),
  response.hidden.layer = c(4, 2),
  compl.stepmax = 1e+08,
  response.stepmax = 1e+08,
  ID = NULL,
  cluster = NULL,
  bootse = FALSE,
  bootp = FALSE,
  bootn = 999,
  binary.outcome = TRUE
)
}
\arguments{
\item{response.formula}{formula of response variable as outcome and
covariates (y ~ x)}

\item{exp.data}{\code{data.frame} of experimental data. Must include binary
treatment and compliance variables.}

\item{pop.data}{\code{data.frame} of population data. Must include binary
compliance variable}

\item{treat.var}{string for treatment variable.}

\item{compl.var}{string for compliance variable}

\item{compl.algorithm}{string for algorithim to train neural network for
compliance model. Default set to \code{"rprop+"}. See (\code{neuralnet} package for
available algorithms).}

\item{response.algorithm}{string for algorithim to train neural network for
response model. Default set to \code{"rprop+"}. See (\code{neuralnet} package for
available algorithms).}

\item{compl.hidden.layer}{vector for specifying hidden layers and number of
neurons in complier model.}

\item{response.hidden.layer}{vector for specifying hidden layers and number of
neurons in response model.}

\item{compl.stepmax}{maximum number of steps for complier model}

\item{response.stepmax}{maximum number of steps for response model}

\item{ID}{string for identifier variable}

\item{cluster}{string for cluster variable.}

\item{bootse}{logical for bootstrapped standard erros.}

\item{bootp}{logical for bootstrapped p values.}

\item{bootn}{logical for number of bootstraps.}

\item{binary.outcome}{logical specifying predicted outcome variable will take
binary values or proportions.}
}
\value{
results of t test as PATTC estimate.
}
\description{
estimates the Population Average Treatment Effect
of the Treated from experimental data with noncompliers using Deep Neural
Networks.
}
\examples{
\donttest{
# load datasets
data(exp_data) #experimental data
data(pop_data) #population data
# specify models and estimate PATTC
set.seed(123456)
pattc_neural <- pattc_deepneural(response.formula = support_war ~ age + female +
                               income + education +  employed + married +
                               hindu + job_loss,
                               exp.data = exp_data,
                               pop.data = pop_data,
                               treat.var = "strong_leader",
                               compl.var = "compliance",
                               compl.algorithm = "rprop+",
                               response.algorithm = "rprop+",
                               compl.hidden.layer = c(4,2),
                               response.hidden.layer = c(4,2),
                               compl.stepmax = 1e+09,
                               response.stepmax = 1e+09,
                               ID = NULL,
                               cluster = NULL,
                               bootse = FALSE,
                               bootp = FALSE,
                               bootn = 999,
                               binary.outcome = TRUE)

summary(pattc_neural)
}

}
