/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.UIManager;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.toolkit.PrefDialog;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;
import org.rosuda.deducer.DefaultRConnector;
import org.rosuda.deducer.JGRConnector;
import org.rosuda.deducer.MonitoredEval;
import org.rosuda.deducer.RConnector;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.data.DataFrameSelector;
import org.rosuda.deducer.data.DataViewer;
import org.rosuda.deducer.menu.ContingencyDialog;
import org.rosuda.deducer.menu.CorDialog;
import org.rosuda.deducer.menu.DescriptivesDialog;
import org.rosuda.deducer.menu.FactorDialog;
import org.rosuda.deducer.menu.FrequencyDialog;
import org.rosuda.deducer.menu.KSampleDialog;
import org.rosuda.deducer.menu.MergeDialog;
import org.rosuda.deducer.menu.OneSampleDialog;
import org.rosuda.deducer.menu.RecodeDialog;
import org.rosuda.deducer.menu.SortDialog;
import org.rosuda.deducer.menu.SubsetDialog;
import org.rosuda.deducer.menu.TransformDialog;
import org.rosuda.deducer.menu.twosample.TwoSampleDialog;
import org.rosuda.deducer.models.GLMDialog;
import org.rosuda.deducer.models.LinearDialog;
import org.rosuda.deducer.models.LogisticDialog;
import org.rosuda.deducer.plots.PlotBuilder;
import org.rosuda.deducer.plots.PlotBuilderModel;
import org.rosuda.deducer.plots.PlotController;
import org.rosuda.deducer.plots.PlottingElement;
import org.rosuda.deducer.plots.PlottingElementMenuDialog;
import org.rosuda.deducer.toolkit.DeducerPrefs;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.LoadData;
import org.rosuda.deducer.toolkit.PrefPanel;
import org.rosuda.deducer.toolkit.SaveData;
import org.rosuda.deducer.toolkit.VariableSelectionDialog;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.util.Platform;

public class Deducer {
    ConsoleListener cListener = new ConsoleListener();
    static final int MENUMODIFIER = Common.isMac() ? 4 : 2;
    static int menuIndex = 3;
    static String recentActiveData = "";
    static final String Version = "0.7-6";
    public static String guiEnv = ".gui.working.env";
    public static boolean insideJGR;
    public static boolean started;
    private static RConnector rConnection;

    public Deducer(boolean bl) {
        started = false;
        Common.getScreenRes();
        try {
            if (bl && JGR.isJGRmain()) {
                this.startWithJGR();
                new Thread(){

                    public void run() {
                        if (DeducerPrefs.VIEWERATSTARTUP) {
                            DataViewer dataViewer = new DataViewer();
                            dataViewer.setLocationRelativeTo(null);
                            dataViewer.setVisible(true);
                            JGR.MAINRCONSOLE.toFront();
                        }
                        new Thread(new DataRefresher()).start();
                    }
                }.start();
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void startNoJGR() {
        try {
            insideJGR = false;
            String string = UIManager.getSystemLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            Platform.initPlatform("org.rosuda.JGR.toolkit.");
            try {
                rConnection = new DefaultRConnector(new JRIEngine(Rengine.getMainEngine()));
            }
            catch (REngineException rEngineException) {
                new ErrorMsg((Exception)rEngineException);
            }
            DeducerPrefs.initialize();
            started = true;
            Deducer.timedEval("JavaGD:::.javaGD.set.class.path(\"org/rosuda/JGR/JavaGD\")");
            new Thread(new DataRefresher()).start();
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void startWithJGR() {
        insideJGR = true;
        rConnection = new JGRConnector();
        String string = "Data";
        String string2 = "Analysis";
        try {
            Object object;
            int n;
            String[] stringArray;
            DeducerPrefs.initialize();
            if (DeducerPrefs.SHOWDATA) {
                Deducer.insertMenu((JFrame)JGR.MAINRCONSOLE, string, menuIndex);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Edit Factor", "factor", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Recode Variables", "recode", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Transform", "transform", this.cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, string).addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Reset Row Names", "reset rows", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Sort", "sort", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Transpose", "trans", this.cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, string).addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Merge Data", "merge", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Subset", "subset", this.cListener);
                ++menuIndex;
            }
            if (DeducerPrefs.SHOWANALYSIS) {
                Deducer.insertMenu((JFrame)JGR.MAINRCONSOLE, string2, menuIndex);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Frequencies", "frequency", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Descriptives", "descriptives", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Contingency Tables", "contingency", this.cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, string2).addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "One Sample Test", "onesample", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Two Sample Test", "two sample", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "K-Sample Test", "ksample", this.cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, string2).addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Paired Test", "pairedtest", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Correlation", "corr", this.cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, string2).addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Linear Model", "linear", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Logistic Model", "logistic", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Generalized Linear Model", "glm", this.cListener);
                ++menuIndex;
            }
            Deducer.insertMenu((JFrame)JGR.MAINRCONSOLE, "Plots", menuIndex);
            EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, "Plots", "Plot Builder", "plotbuilder", this.cListener);
            EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, "Plots", "Import Template", "Import template", this.cListener);
            EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, "Plots", "Open Plot", "Open plot", this.cListener);
            JMenu jMenu = new JMenu("Quick");
            jMenu.setMnemonic(83);
            String[] stringArray2 = PlotController.getTemplateNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray = new JMenuItem();
                stringArray.setText(stringArray2[i].replace('_', ' '));
                stringArray.setActionCommand("template___" + stringArray2[i]);
                stringArray.addActionListener(this.cListener);
                jMenu.add((JMenuItem)stringArray);
            }
            JMenu jMenu2 = EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, "Plots");
            jMenu2.add(jMenu);
            jMenu2.addSeparator();
            jMenu = new JMenu("Interactive");
            jMenu.setMnemonic(83);
            stringArray2 = new String[]{"Scatter", "Histogram", "Bar", "Box-plot (long)", "Box-plot (wide)", "Mosaic", "Parallel Coordinate"};
            stringArray = new String[]{"iplot", "ihist", "ibar", "iboxl", "iboxw", "imosaic", "ipcp"};
            for (n = 0; n < stringArray2.length; ++n) {
                object = new JMenuItem();
                ((AbstractButton)object).setText(stringArray2[n]);
                ((AbstractButton)object).setActionCommand(stringArray[n]);
                ((AbstractButton)object).addActionListener(this.cListener);
                jMenu.add((JMenuItem)object);
            }
            jMenu2.add(jMenu);
            JGR.MAINRCONSOLE.getJMenuBar().getMenu(++menuIndex).remove(1);
            Deducer.insertJMenuItem((JFrame)JGR.MAINRCONSOLE, "Packages & Data", "Data Viewer", "table", this.cListener, 1);
            jMenu = new JMenu("GUI Add-ons");
            jMenu.setMnemonic(83);
            stringArray2 = new String[]{"Text", "Psychometrics", "Extras", "Spatial"};
            stringArray = new String[]{"DeducerText", "DeducerPlugInScaling", "DeducerExtras", "DeducerSpatial"};
            for (n = 0; n < stringArray2.length; ++n) {
                object = new JMenuItem();
                ((AbstractButton)object).setText(stringArray2[n]);
                ((AbstractButton)object).setActionCommand(stringArray[n]);
                ((AbstractButton)object).addActionListener(this.cListener);
                jMenu.add((JMenuItem)object);
            }
            EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, "Packages & Data").add((Component)jMenu, 3);
            JGR.MAINRCONSOLE.getJMenuBar().getMenu(0).remove(0);
            Deducer.insertJMenuItem((JFrame)JGR.MAINRCONSOLE, "File", "New Data", "New Data Set", this.cListener, 0);
            JGR.MAINRCONSOLE.getJMenuBar().getMenu(0).remove(1);
            Deducer.insertJMenuItem((JFrame)JGR.MAINRCONSOLE, "File", "Open Data", "Open Data Set", this.cListener, 1);
            JMenuItem jMenuItem = (JMenuItem)JGR.MAINRCONSOLE.getJMenuBar().getMenu(0).getMenuComponent(1);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, MENUMODIFIER));
            Deducer.insertJMenuItem((JFrame)JGR.MAINRCONSOLE, "File", "Save Data", "Save Data Set", this.cListener, 2);
            EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, "Help", "Deducer Help", "dhelp", this.cListener);
            object = new PrefPanel();
            PrefDialog.addPanel((PrefDialog.PJPanel)object, (ActionListener)object);
            started = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new ErrorMsg(exception);
        }
    }

    public static boolean isJGR() {
        return insideJGR;
    }

    public void detach() {
        JMenuBar jMenuBar = JGR.MAINRCONSOLE.getJMenuBar();
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            if (!jMenuBar.getMenu(i).getText().equals("Data") && !jMenuBar.getMenu(i).getText().equals("Analysis")) continue;
            jMenuBar.remove(i);
            --i;
        }
    }

    public static void startViewerAndWait() {
        DataViewer dataViewer = new DataViewer();
        dataViewer.setLocationRelativeTo(null);
        dataViewer.setVisible(true);
        while (!dataViewer.isVisible()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static String addSlashes(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '\\') {
                stringBuffer.insert(i++, '\\');
                continue;
            }
            if (stringBuffer.charAt(i) == '\"') {
                stringBuffer.insert(i++, '\\');
                continue;
            }
            if (stringBuffer.charAt(i) != '\'') continue;
            stringBuffer.insert(i++, '\\');
        }
        return stringBuffer.toString();
    }

    public static void runCmdThreaded(String string) {
        final String string2 = string;
        new Thread(){

            public void run() {
                Deducer.runCmd(string2, false);
            }
        }.start();
    }

    public static void runCmd(String string, boolean bl) {
        boolean bl2 = false;
        if (string.equals("dhelp")) {
            HelpButton.showInBrowser(HelpButton.baseUrl + "pmwiki.php?n=Main.DeducerManual");
        } else if (string.equals("New Data Set")) {
            String string2 = JOptionPane.showInputDialog("Data Name: ");
            if (string2 != null) {
                String string3 = RController.makeValidVariableName((String)string2.trim());
                Deducer.execute(string3 + "<-data.frame()");
            }
        } else if (string.equals("Open Data Set")) {
            LoadData loadData = new LoadData();
            Deducer.setRecentData(loadData.getDataName());
        } else if (string.equals("Save Data Set")) {
            RObject rObject = new DataFrameSelector((Frame)JGR.MAINRCONSOLE).getSelection();
            if (rObject != null) {
                SaveData saveData = new SaveData(rObject.getName());
            }
        } else if (string.equals("recode")) {
            bl2 = true;
            RecodeDialog recodeDialog = new RecodeDialog((JFrame)JGR.MAINRCONSOLE);
            recodeDialog.setLocationRelativeTo(null);
            recodeDialog.setVisible(true);
            WindowTracker.addWindow(recodeDialog);
        } else if (string.equals("transform")) {
            bl2 = true;
            TransformDialog transformDialog = new TransformDialog((JFrame)JGR.MAINRCONSOLE);
            transformDialog.setLocationRelativeTo(null);
            transformDialog.setVisible(true);
            WindowTracker.addWindow(transformDialog);
        } else if (string.equals("factor")) {
            bl2 = true;
            VariableSelectionDialog variableSelectionDialog = new VariableSelectionDialog((JFrame)JGR.MAINRCONSOLE);
            variableSelectionDialog.SetSingleSelection(true);
            variableSelectionDialog.setLocationRelativeTo(null);
            variableSelectionDialog.setRFilter("is.factor");
            variableSelectionDialog.setTitle("Select Factor to Edit");
            variableSelectionDialog.setVisible(true);
            String string4 = variableSelectionDialog.getSelecteditem();
            if (string4 == null) {
                return;
            }
            FactorDialog factorDialog = new FactorDialog((JFrame)JGR.MAINRCONSOLE, string4);
            factorDialog.setLocationRelativeTo(null);
            factorDialog.setVisible(true);
            WindowTracker.addWindow(factorDialog);
        } else if (string.equals("reset rows")) {
            String string5 = null;
            RObject rObject = null;
            DataFrameSelector dataFrameSelector = new DataFrameSelector((Frame)JGR.MAINRCONSOLE);
            rObject = dataFrameSelector.getSelection();
            if (rObject != null) {
                string5 = rObject.getName();
                Deducer.execute("rownames(" + string5 + ") <-1:dim(" + string5 + ")[1]");
            }
            JGR.MAINRCONSOLE.toFront();
        } else if (string.equals("sort")) {
            bl2 = true;
            SortDialog sortDialog = new SortDialog((JFrame)JGR.MAINRCONSOLE);
            sortDialog.setLocationRelativeTo(null);
            sortDialog.setVisible(true);
            WindowTracker.addWindow(sortDialog);
        } else if (string.equals("merge")) {
            bl2 = true;
            MergeDialog mergeDialog = new MergeDialog((JFrame)JGR.MAINRCONSOLE);
            mergeDialog.setLocationRelativeTo(null);
            mergeDialog.setVisible(true);
            WindowTracker.addWindow(mergeDialog);
        } else if (string.equals("trans")) {
            String string6 = null;
            RObject rObject = null;
            DataFrameSelector dataFrameSelector = new DataFrameSelector((Frame)JGR.MAINRCONSOLE);
            rObject = dataFrameSelector.getSelection();
            if (rObject != null) {
                string6 = rObject.getName();
                String string7 = JOptionPane.showInputDialog("New dataset name:");
                string7 = Deducer.makeValidVariableName(string7);
                Deducer.execute(string7 + "<-as.data.frame(t(" + string6 + "))");
            }
        } else if (string.equals("subset")) {
            bl2 = true;
            SubsetDialog subsetDialog = new SubsetDialog((JFrame)JGR.MAINRCONSOLE);
            subsetDialog.setLocationRelativeTo(null);
            subsetDialog.setVisible(true);
            WindowTracker.addWindow(subsetDialog);
        } else if (string.equals("frequency")) {
            bl2 = true;
            FrequencyDialog frequencyDialog = new FrequencyDialog((JFrame)JGR.MAINRCONSOLE);
            WindowTracker.addWindow(frequencyDialog);
            frequencyDialog.setLocationRelativeTo(null);
            frequencyDialog.setVisible(true);
        } else if (string.equals("descriptives")) {
            bl2 = true;
            DescriptivesDialog descriptivesDialog = new DescriptivesDialog((JFrame)JGR.MAINRCONSOLE);
            descriptivesDialog.setLocationRelativeTo(null);
            descriptivesDialog.setVisible(true);
            WindowTracker.addWindow(descriptivesDialog);
        } else if (string.equals("contingency")) {
            bl2 = true;
            ContingencyDialog contingencyDialog = new ContingencyDialog((JFrame)JGR.MAINRCONSOLE);
            contingencyDialog.setLocationRelativeTo(null);
            contingencyDialog.setVisible(true);
            WindowTracker.addWindow(contingencyDialog);
        } else if (string.equals("table")) {
            bl2 = true;
            DataViewer dataViewer = new DataViewer();
            dataViewer.setLocationRelativeTo(null);
            dataViewer.setVisible(true);
            WindowTracker.addWindow(dataViewer);
        } else if (string.equals("pairedtest")) {
            Deducer.timedEval(".getDialog('Paired Test')$run()");
        } else if (string.equals("onesample")) {
            bl2 = true;
            OneSampleDialog oneSampleDialog = new OneSampleDialog((JFrame)JGR.MAINRCONSOLE);
            oneSampleDialog.setLocationRelativeTo((Component)JGR.MAINRCONSOLE);
            oneSampleDialog.setVisible(true);
            WindowTracker.addWindow(oneSampleDialog);
        } else if (string.equals("two sample")) {
            bl2 = true;
            TwoSampleDialog twoSampleDialog = new TwoSampleDialog((JFrame)JGR.MAINRCONSOLE);
            twoSampleDialog.setLocationRelativeTo(null);
            twoSampleDialog.setVisible(true);
            WindowTracker.addWindow(twoSampleDialog);
        } else if (string.equals("ksample")) {
            bl2 = true;
            KSampleDialog kSampleDialog = new KSampleDialog((JFrame)JGR.MAINRCONSOLE);
            kSampleDialog.setLocationRelativeTo(null);
            kSampleDialog.setVisible(true);
            WindowTracker.addWindow(kSampleDialog);
        } else if (string.equals("corr")) {
            bl2 = true;
            CorDialog corDialog = new CorDialog((JFrame)JGR.MAINRCONSOLE);
            corDialog.setLocationRelativeTo(null);
            corDialog.setVisible(true);
            WindowTracker.addWindow(corDialog);
        } else if (string.equals("glm")) {
            bl2 = true;
            GLMDialog gLMDialog = new GLMDialog((JFrame)JGR.MAINRCONSOLE);
            gLMDialog.setLocationRelativeTo(null);
            gLMDialog.setVisible(true);
            WindowTracker.addWindow(gLMDialog);
        } else if (string.equals("logistic")) {
            bl2 = true;
            LogisticDialog logisticDialog = new LogisticDialog((JFrame)JGR.MAINRCONSOLE);
            logisticDialog.setLocationRelativeTo(null);
            logisticDialog.setVisible(true);
            WindowTracker.addWindow(logisticDialog);
        } else if (string.equals("linear")) {
            bl2 = true;
            LinearDialog linearDialog = new LinearDialog((JFrame)JGR.MAINRCONSOLE);
            linearDialog.setLocationRelativeTo(null);
            linearDialog.setVisible(true);
            WindowTracker.addWindow(linearDialog);
        } else if (string.equals("plotbuilder")) {
            bl2 = true;
            PlotBuilder plotBuilder = new PlotBuilder();
            plotBuilder.setLocationRelativeTo(null);
            plotBuilder.setVisible(true);
            WindowTracker.addWindow(plotBuilder);
        } else if (string.equals("Open plot")) {
            bl2 = true;
            FileSelector fileSelector = new FileSelector(null, "Open plot", 0, null, true);
            fileSelector.setVisible(true);
            File file = fileSelector.getSelectedFile();
            if (file != null) {
                if (!file.getName().endsWith(".ggp")) {
                    JOptionPane.showMessageDialog(null, "This does not appear to be a ggplot2 PlotBuilder file (extension .ggp)");
                    return;
                }
                if (file != null && file.exists()) {
                    PlotBuilderModel plotBuilderModel = new PlotBuilderModel();
                    plotBuilderModel.setFromFile(file);
                    PlotBuilder plotBuilder = new PlotBuilder(plotBuilderModel);
                    plotBuilder.setLocationRelativeTo(null);
                    plotBuilder.setVisible(true);
                    WindowTracker.addWindow(plotBuilder);
                }
            }
        } else if (string.equals("Import template")) {
            FileSelector fileSelector = new FileSelector(null, "Import template", 0, null, true);
            fileSelector.setVisible(true);
            if (fileSelector.getFile() != null) {
                File file = fileSelector.getSelectedFile();
                if (!file.getName().endsWith(".ggtmpl")) {
                    JOptionPane.showMessageDialog(null, "This does not appear to be a ggplot2 template file (extension .ggtmpl)");
                    return;
                }
                if (file != null && file.exists()) {
                    PlottingElement plottingElement = new PlottingElement();
                    plottingElement.setFromFile(file);
                    PlotController.addTemplate(plottingElement);
                }
            }
        } else if (string.startsWith("template___")) {
            try {
                PlotController.init();
                String string8 = string.split("___")[1];
                PlottingElementMenuDialog plottingElementMenuDialog = PlotController.getMenuDialog(string8);
                plottingElementMenuDialog.setLocationRelativeTo(null);
                plottingElementMenuDialog.setVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string.equals("iplot")) {
            Deducer.timedEval(".getDialog('Interactive Scatter Plot')$run()");
        } else if (string.equals("ihist")) {
            Deducer.timedEval(".getDialog('Interactive Histogram')$run()");
        } else if (string.equals("ibar")) {
            Deducer.timedEval(".getDialog('Interactive Bar Plot')$run()");
        } else if (string.equals("iboxl")) {
            Deducer.timedEval(".getDialog('Interactive Box Plot Long')$run()");
        } else if (string.equals("iboxw")) {
            Deducer.timedEval(".getDialog('Interactive Box Plot Wide')$run()");
        } else if (string.equals("imosaic")) {
            Deducer.timedEval(".getDialog('Interactive Mosaic Plot')$run()");
        } else if (string.equals("ipcp")) {
            Deducer.timedEval(".getDialog('Interactive Parallel Coordinate Plot')$run()");
        } else if (string.startsWith("Deducer")) {
            RController.loadPackage((String)string);
        }
        if (bl2 && bl && !Deducer.isJGR()) {
            WindowTracker.waitForAllClosed();
        }
    }

    public static void insertMenu(JFrame jFrame, String string, int n) {
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        JMenu jMenu = EzMenuSwing.getMenu(jFrame, string);
        if (jMenu == null && n < jMenuBar.getMenuCount()) {
            JMenuBar jMenuBar2 = new JMenuBar();
            int n2 = jMenuBar.getMenuCount();
            for (int i = 0; i < n2; ++i) {
                if (i == n) {
                    jMenuBar2.add(new JMenu(string));
                }
                jMenuBar2.add(jMenuBar.getMenu(0));
            }
            jFrame.setJMenuBar(jMenuBar2);
        } else if (jMenu == null && n == jMenuBar.getMenuCount()) {
            EzMenuSwing.addMenu(jFrame, string);
        }
    }

    public static void insertJMenuItem(JFrame jFrame, String string, String string2, String string3, ActionListener actionListener, int n) {
        JMenu jMenu = EzMenuSwing.getMenu(jFrame, string);
        JMenuItem jMenuItem = new JMenuItem(string2);
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setActionCommand(string3);
        jMenu.insert(jMenuItem, n);
    }

    public static String getRecentData() {
        return recentActiveData;
    }

    public static void setRecentData(String string) {
        recentActiveData = string;
    }

    public static REngine getREngine() {
        return rConnection.getREngine();
    }

    public static RConnector getRConnector() {
        return rConnection;
    }

    public static void setRConnector(RConnector rConnector) {
        rConnection = rConnector;
    }

    public static REXP eval(String string) {
        return rConnection.eval(string);
    }

    public static void threadedEval(String string) {
        final String string2 = string;
        new Thread(new Runnable(){

            public void run() {
                rConnection.eval(string2);
            }
        }).start();
    }

    public static REXP timedEval(String string) {
        return Deducer.timedEval(string, 15000, true);
    }

    public static REXP timedEval(String string, boolean bl) {
        return Deducer.timedEval(string, 15000, bl);
    }

    public static REXP timedEval(String string, int n, boolean bl) {
        return new MonitoredEval(n, bl).run(string);
    }

    public static REXP idleEval(String string) {
        return rConnection.idleEval(string);
    }

    public static void execute(String string) {
        rConnection.execute(string);
    }

    public static void execute(String string, boolean bl) {
        rConnection.execute(string, bl);
    }

    public static void executeAndContinue(String string) {
        final String string2 = string;
        new Thread(){

            public void run() {
                Deducer.execute(string2);
            }
        }.start();
    }

    public static String makeValidVariableName(String string) {
        return string.replaceAll("[ -+*/\\()=!~`@#$%^&*<>,?;:\"']", ".");
    }

    public static String makeFormula(DefaultListModel defaultListModel, DefaultListModel defaultListModel2) {
        int n;
        String string = "";
        if (defaultListModel.getSize() == 1) {
            string = string + defaultListModel.get(0) + " ~ ";
        } else {
            string = string + "cbind(";
            for (n = 0; n < defaultListModel.getSize(); ++n) {
                string = string + defaultListModel.get(n);
                if (n >= defaultListModel.getSize() - 1) continue;
                string = string + ",";
            }
            string = string + ") ~ ";
        }
        for (n = 0; n < defaultListModel2.getSize(); ++n) {
            string = string + defaultListModel2.get(n);
            if (n >= defaultListModel2.getSize() - 1) continue;
            string = string + " + ";
        }
        return string;
    }

    public static String makeRCollection(Collection collection, String string, boolean bl) {
        String string2 = "";
        if (bl) {
            string2 = "\"";
        }
        if (collection.size() == 0) {
            return string + "()";
        }
        String string3 = string + "(";
        Iterator iterator = collection.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            String string4 = iterator.next().toString();
            string3 = string3 + string2 + string4 + string2;
            if (iterator.hasNext()) {
                string3 = string3 + ",";
            }
            if (n % 10 == 9) {
                string3 = string3 + "\n";
            }
            ++n;
        }
        return string3 + ")";
    }

    public static String makeRCollection(ListModel listModel, String string, boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < listModel.getSize(); ++i) {
            arrayList.add(listModel.getElementAt(i));
        }
        return Deducer.makeRCollection(arrayList, string, bl);
    }

    public static String makeRCollection(String[] stringArray, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return Deducer.makeRCollection(arrayList, string, bl);
    }

    public static String getUniqueName(String string) {
        JGR.refreshObjects();
        string = RController.makeValidVariableName((String)string);
        if (!JGR.OBJECTS.contains(string)) {
            return string;
        }
        int n = 1;
        while (JGR.OBJECTS.contains(string + n)) {
            ++n;
        }
        return string + n;
    }

    public static String getUniqueName(String string, String string2) {
        string = RController.makeValidVariableName((String)string);
        try {
            REXPLogical rEXPLogical = (REXPLogical)Deducer.eval("is.environment(" + string2 + ")");
            boolean bl = rEXPLogical.isTRUE()[0];
            if (!bl) {
                return string;
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
            return string;
        }
        boolean bl = false;
        try {
            REXPLogical rEXPLogical = (REXPLogical)Deducer.eval("exists('" + string + "',where=" + string2 + ",inherits=FALSE)");
            bl = rEXPLogical.isFALSE()[0];
            if (bl) {
                return string;
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
            return string;
        }
        int n = 1;
        while (true) {
            try {
                REXPLogical rEXPLogical = (REXPLogical)Deducer.eval("exists('" + string + n + "',where=" + string2 + ",inherits=FALSE)");
                bl = rEXPLogical.isFALSE()[0];
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
            if (bl) {
                return string + n;
            }
            ++n;
        }
    }

    public static boolean isInstalled(String string) {
        REXP rEXP = Deducer.eval("'" + string + "' %in% installed.packages()[,1]");
        if (rEXP != null && rEXP instanceof REXPLogical) {
            return ((REXPLogical)rEXP).isTRUE()[0];
        }
        return false;
    }

    public static boolean isLoaded(String string) {
        REXP rEXP = Deducer.eval("'" + string + "' %in% c(names(sessionInfo()$otherPkgs), sessionInfo()$base)");
        if (rEXP != null && rEXP instanceof REXPLogical) {
            return ((REXPLogical)rEXP).isTRUE()[0];
        }
        return false;
    }

    public static String requirePackage(String string) {
        if (Deducer.isLoaded(string)) {
            return "loaded";
        }
        if (Deducer.isInstalled(string)) {
            return "installed";
        }
        int n = JOptionPane.showOptionDialog(null, "Package " + string + " not installed. \nWould you like to install it now?", "Install", 0, 3, null, new String[]{"Yes", "No"}, "Yes");
        if (n == 0) {
            Deducer.eval("install.packages('" + string + "',,'http://cran.r-project.org')");
            if (Deducer.isInstalled(string)) {
                return "installed";
            }
        }
        return "not-installed";
    }

    public static synchronized void refreshData() {
        REXP rEXP = Deducer.idleEval(".getDataObjects()");
        if (rEXP == null) {
            return;
        }
        JGR.DATA.clear();
        try {
            String[] stringArray;
            if (!rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                int n = 1;
                for (int i = 0; i < stringArray.length; ++i) {
                    boolean bl = stringArray[i].equals("null") || stringArray[i].trim().length() == 0;
                    String string = bl ? n + "" : stringArray[i];
                    JGR.DATA.add(RController.createRObject((String)string, (String)stringArray[++i], null, (!bl ? 1 : 0) != 0));
                    ++n;
                }
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
    }

    public static Vector getData() {
        return JGR.DATA;
    }

    static {
        rConnection = null;
    }

    class DataRefresher
    implements Runnable {
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                        Deducer.refreshData();
                    }
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                    continue;
                }
                break;
            }
        }
    }

    class ConsoleListener
    implements ActionListener {
        ConsoleListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Deducer.runCmdThreaded(string);
        }
    }
}

