% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_saturation.R
\name{compare_saturation}
\alias{compare_saturation}
\title{Compare Code Saturation Across Threshold Sets}
\usage{
compare_saturation(
  code_summary,
  thresholds_list,
  output_type = c("tibble", "kable"),
  plot = FALSE,
  plot_metric = c("count", "prop", "both")
)
}
\arguments{
\item{code_summary}{A data frame or tibble, typically produced by
\code{\link[=create_code_summary]{create_code_summary()}}, containing columns:
\code{code}, \code{count}, \code{n_media_titles}, and \code{prop_media_titles}.}

\item{thresholds_list}{A named list of threshold sets. Each element should
be a list with numeric elements \code{code_count} and \code{prop_media_title}.
For example:
\code{list(Liberal = list(code_count = 3, prop_media_title = 0.2),
  Strict = list(code_count = 5, prop_media_title = 0.5))}.}

\item{output_type}{Character string specifying the output type:
either \code{"tibble"} (default) or \code{"kable"} for a formatted table.}

\item{plot}{Logical; if \code{TRUE}, generates a ggplot visualization
of which codes meet each threshold set.}

\item{plot_metric}{Character string specifying which metric to plot:
\itemize{
\item \code{"count"} — show excerpt frequencies only.
\item \code{"prop"} — show proportions of media titles only.
\item \code{"both"} — show both metrics with dual y-axes
(counts on the bottom axis, proportions on the top axis).
}}
}
\value{
If \code{plot = FALSE}, returns either a tibble or kable table of results.
If \code{plot = TRUE}, returns a list with:
\itemize{
\item \code{results}: the tibble or kable table with logical columns indicating which codes meet each threshold set.
\item \code{plot}: a ggplot2 object visualizing saturation across threshold sets.
}
}
\description{
This function compares code saturation results from a code summary table
(typically generated by \code{\link[=create_code_summary]{create_code_summary()}}) against one or more
threshold sets that define what constitutes "saturation" based on the
number of excerpts (\code{count}) and proportion of media titles (\code{prop_media_titles})
where each code appears.

Optionally, the function can produce a faceted bar plot showing which codes
meet each set of thresholds, with metrics plotted as counts, proportions, or both.
}
\details{
Each threshold set is applied independently. A code is considered to meet a
given threshold set if both its excerpt count and proportion of media titles
are greater than or equal to the respective thresholds.
}
\examples{
# Example data: excerpts with coded logical columns
set.seed(123)
excerpts <- data.frame(
  media_title = rep(paste0("Interview_", 1:5), each = 3),
  code_A = sample(c(TRUE, FALSE), 15, replace = TRUE),
  code_B = sample(c(TRUE, FALSE), 15, replace = TRUE),
  code_C = sample(c(TRUE, FALSE), 15, replace = TRUE)
)

# Create a code summary table (from your package function)
code_summary <- create_code_summary(excerpts, output_type = "tibble")

# Define two saturation threshold sets
thresholds_list <- list(
  Liberal = list(code_count = 3, prop_media_title = 0.2),
  Strict  = list(code_count = 5, prop_media_title = 0.5)
)

# Compare saturation (table only)
compare_saturation(code_summary, thresholds_list)

# Compare and plot using proportions
res <- compare_saturation(code_summary, thresholds_list, plot = TRUE, plot_metric = "prop")
res$plot

# Compare and plot both metrics with dual y-axes
res2 <- compare_saturation(code_summary, thresholds_list, plot = TRUE, plot_metric = "both")
res2$plot

}
