% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema_source.R
\name{schema_source}
\alias{schema_source}
\title{Source schema file into dependency graph object}
\usage{
schema_source(
  source,
  schema = "public",
  file = if (is.character(source)) source else file.path(getwd(), "schema.yml"),
  faker_opts = getOption("dfkr_options", default_faker_opts)
)
}
\arguments{
\item{source}{Connection to Redshift or Postgres database or path to YAML configuration file
from which schema metadata should be sourced.
When missing \code{file} defined file will be sourced if existing.}

\item{schema}{Schema name from which the structure should be sourced.}

\item{file}{Path to yaml file describing database schema, or target file when schema should be saved
(when \code{db_conn} not mising). See \code{vignette('todo')}.}

\item{faker_opts}{Structure sourcing and columns simulation config.}
}
\description{
The functions parses table schema (from database) and saves its structure yaml format.
The defined structure is then used to prepare schema dependency graph, that is:
\itemize{
  \item{dependencies between tables}{Based on foreign key definitions}
  \item{inner table column dependencies}{Based on defined dependencies by various methods. See \code{vignette('todo')}.}
}
}
\details{
Detected dependencies are then saved in R6Class object that is returned and possible to pass for further methods.
See \link{schema_methods}.

Keeping the schema as a graph allows to perform simulation process in proper order,
preserving table dependencies and constraints.
}
