% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_missing.r
\name{plot_missing}
\alias{plot_missing}
\title{Plot missing value profile}
\usage{
plot_missing(data, group = list(Good = 0.05, OK = 0.4, Bad = 0.8, Remove
  = 1), geom_label_args = list(), title = NULL,
  ggtheme = theme_gray(), theme_config = list(legend.position =
  c("bottom")))
}
\arguments{
\item{data}{input data}

\item{group}{missing profile band taking a list of group name and group upper bounds. Default is \code{list("Good" = 0.05, "OK" = 0.4, "Bad" = 0.8, "Remove" = 1)}.}

\item{geom_label_args}{a list of other arguments to \link{geom_label}}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}
}
\value{
invisibly return the ggplot object
}
\description{
This function returns and plots frequency of missing values for each feature.
}
\examples{
plot_missing(airquality)

## Customize band
plot_missing(airquality, group = list("B1" = 0, "B2" = 0.06, "B3" = 1))

## Shrink geom_label size
library(ggplot2)
plot_missing(airquality, geom_label_args = list("size" = 2, "label.padding" = unit(0.1, "lines")))
}
\seealso{
\link{profile_missing}
}
\keyword{plot_missing}
