% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FillIn.R
\name{FillDown}
\alias{FillDown}
\title{Fills in missing (NA) values with the previous non-missing value}
\usage{
FillDown(data, Var)
}
\arguments{
\item{data}{a data frame. Optional as you can simply specify a vector with
\code{Var},}

\item{Var}{the variable in \code{data} or a vector you would like to fill 
down missing (\code{NA}) values.}
}
\value{
data frame
}
\description{
Fills in missing (NA) values with the previous non-missing value
}
\examples{
# Create fake data
id <- c('Algeria', NA, NA, NA, 'Mexico', NA, NA)
score <- rnorm(7)
Data <- data.frame(id, score)

# FillDown id
DataOut <- FillDown(Data, 'id')

\dontrun{
# Use group_by and mutate from dplyr to FillDown grouped data, e.g.:
Example <- Example \%>\% group_by(grouping) \%>\% 
             mutate(NewFilled = FillDown(Var = VarToFill))
}
}

