/***********************************************************************
* mexMatvec: compute
* 
* mexMatvec(A,y,options)
*          
*  options = 0, compute A*y
*          = 1, compute (y'*A)' 
*
%% SDPT3: version 3.1 
%% Copyright (c) 1997 by
%% K.C. Toh, M.J. Todd, R.H. Tutuncu
%% Last Modified: 15 Sep 2004
************************************************************************/

#include <R.h>
#include <math.h>

#if !defined(MAX)
#define  MAX(A, B)   ((A) > (B) ? (A) : (B))
#endif

/********************************
* realdotde: x dense matrix,  
*            y dense vector
*********************************/
double realdotde(const double *x, const int idx, 
                 const double *y, const int n)

{  int i;
   double r; 

   r=0.0;
   for (i=0; i<n-3; i++) {             /* LEVEL 4 */
      r += x[i+idx] * y[i]; i++;
      r += x[i+idx] * y[i]; i++;
      r += x[i+idx] * y[i]; i++;
      r += x[i+idx] * y[i]; }
   if (i<n-1) {                        /* LEVEL 2 */
      r += x[i+idx] * y[i]; i++;
      r += x[i+idx] * y[i]; i++; }
   if (i<n) {                          /* LEVEL 1 */
      r += x[i+idx] * y[i]; }
   return r; 
}

/********************************
* saxpymat:  z = z + alpha*y 
* y dense matrix, z dense vector
********************************/
void saxpymat(const double *y,  const int idx1, 
              const int istart, const int iend,
              const double alp, double *z, const int idx2)
{  int i;
  
   for(i=istart; i< iend-3; i++){             /* LEVEL 4 */
      z[i+idx2] += alp * y[i+idx1]; i++;
      z[i+idx2] += alp * y[i+idx1]; i++;
      z[i+idx2] += alp * y[i+idx1]; i++;
      z[i+idx2] += alp * y[i+idx1]; 
   }
   if(i < iend-1){                            /* LEVEL 2 */
      z[i+idx2] += alp * y[i+idx1]; i++;
      z[i+idx2] += alp * y[i+idx1]; i++;
   }
   if(i < iend){                              /* LEVEL 1 */
      z[i+idx2] += alp * y[i+idx1]; 
   }
   return;
}


void mexMatvec_c(double *A, int *m1, int *n1,
		 double *y, double *Ay, int *irA, int *jcA, 
		 int *isspA, int *options){    
  int  j, jm1; 
  int  i, r, k, istart, iend, kstart, kend;
  double  tmp; 
  if (*options==0) {
    if (!(*isspA)) {
      for (j=0; j<*n1; j++){ 
	jm1 = j*(*m1);
	tmp = y[j]; 
	if (tmp !=0) { 
	  saxpymat(A,jm1,0,*m1,tmp,Ay,0); 
	} 
      }
    } else {
      for (j=0; j<*n1; j++){
	tmp = y[j];
	if (tmp != 0) {
	  istart = jcA[j]; iend = jcA[j+1]; 
	  for (i=istart; i<iend; i++) {
	    r = irA[i]; 
	    Ay[r] += tmp*A[i]; }
	}
      }
    }
  } else {
    if (!(*isspA)) {
      for (j=0; j<*n1; j++){ 
	jm1 = j*(*m1); 
	Ay[j] = realdotde(A,jm1,y,*m1); 
      }
    } else {
      for (j=0; j<*n1; j++){
	istart = jcA[j]; iend = jcA[j+1]; 
	tmp = 0; 
	for (i=istart; i<iend; i++) {
	  r = irA[i]; 
	  tmp += y[r]*A[i]; 
	}
	Ay[j] = tmp; 
      }	  
    }
  }
  return;
}


