% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upForcing.R
\name{upForcing}
\alias{upForcing}
\title{Upload Forcings}
\usage{
upForcing(
  path_p = tempdir(),
  path_pet = tempdir(),
  file_type = "raster",
  format = "GTiff"
)
}
\arguments{
\item{path_p}{is a character string that specifies the directory where the precipitation rasters or
the csv file are stored. The csv file must have nrows = N° of cells and ncol= N° of time steps.}

\item{path_pet}{is a character string that specifies the location of the potential evapotranspiration rasters or
the csv file are stored. The csv file must have nrows= N° of cells and ncol= N° of time steps.}

\item{file_type}{Character string that specifies the forcing file formats, it should be "raster" or "csv",
the default value is "raster".}

\item{format}{Character string that specifies the format file of the Rasters, possible values are "GTiff"
and "NetCDF". Default value is "GTiff".}
}
\value{
a list containing the two objects (P and PET).
}
\description{
This function loads the precipitation and evapotranspiration estimates that will be used
to run or force the DWB model (\code{\link{DWBCalculator}}). If files are in raster format, it saves a variable 
cointaining the inputs in table format.
}
\details{
The character strings that control the location of the forcing files are as default "\emph{./precip/}"
and "\emph{./pet/}" for precipitation and potential evapotranspiration, but can be change to other directories.
However, if one's intention is to upload them from NetCDF files, the \bold{strings must be completely changed} to
a complete path that includes the name and extension of the file.
}
\author{
Nicolas Duque Gardeazabal <nduqueg@unal.edu.co> \cr
Pedro Felipe Arboleda <pfarboledao@unal.edu.co> \cr
Carolina Vega Viviescas <cvegav@unal.edu.co> \cr
David Zamora <dazamoraa@unal.edu.co> \cr

Water Resources Engineering Research Group - GIREH
Universidad Nacional de Colombia - sede Bogota
}
