% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varBasins.R
\name{varBasins}
\alias{varBasins}
\title{value of a variable in each subbasin}
\usage{
varBasins(var, cellBasins)
}
\arguments{
\item{var}{one of the dataframe results returned from the DWBcalculator function}

\item{cellBasins}{first entry of the cellBasins function that consists of a list of vectors. Each one of the vectors
contains the cell numbers of each basin}
}
\value{
a list of two elements. The first one is the time series average value of the variable, and the second is a
list of dataframes each one of them contains the time series of each of the cells that are within a basin
}
\description{
This function retrieves the value of a variable in each of the cells that are within a basin boundary.
It also returns the average time series value of the variable.
}
\examples{
data(sogamoso,GRU,basins)
dwb_results <- sogamoso$dwb_results
Run <- dwb_results$q_total
cellBasins <- cellBasins(GRU, basins)
cellBasins <- cellBasins$cellBasins

Runoff.Sogamoso <- varBasins(Run, cellBasins)

}
\author{
Nicolas Duque Gardeazabal <nduqueg@unal.edu.co>  \cr
Pedro Felipe Arboleda Obando <pfarboledao@unal.edu.co>  \cr
Carolina Vega Viviescas <cvegav@unal.edu.co>  \cr
David Zamora <dazamoraa@unal.edu.co> \cr

Water Resources Engineering Research Group - GIREH
Universidad Nacional de Colombia - sede Bogota
}
