## TODO:
## multiple DVH/constraint plots with -> custom renderPlotList(), plotListOutput()
## footer
library(shiny)
source("helper.R")

shinyUI(fluidPage(
    #theme="bootstrap.css",
    titlePanel("Analyze dose-volume histograms using DVHmetrics"),
    sidebarLayout(
        sidebarPanel(width=3,
            conditionalPanel(condition="input.task == 'DVH data'",
                h4("Enter data"),
                radioButtons("DVHin", "",
                             list("Use built-in data"=1,
                                  "Upload DVH file"=2)),
                conditionalPanel(condition="input.DVHin == '2'",
                                 h5("Upload DVH file: "),
                                 fileInput("DVHupload", "Select DVH file:", multiple=TRUE),
                                 radioButtons("DVHtype", "DVH file format:",
                                              list("Eclipse"=1, "Cadplan"=2, "Masterplan"=3)),
                                 radioButtons("DVHplanInfo", "Information encoded in plan:",
                                              list("None"=1, "Prescribed dose"=2))),
                actionButton("applyData", "Apply"),
                radioButtons("DVHverbose", "",
                             list("Short info on DVHs"=1,
                                  "Detailed info on DVHs"=2))
            ),
            conditionalPanel(condition="input.task == 'Metrics'",
                h4("Define metrics"),
                textInput("metrInput", "Metric(s):", value=c("DMEAN, D1cc, V10%")),
                #tags$textarea(id="defMetricsMult", rows=2, cols=10, ""),
                #actionButton('clearText_button','Clear metrics'),
                uiOutput("metrSelPat"),
                uiOutput("metrSelStruct"),
                selectizeInput("metrSortBy", label=h4("Sort output table by:"),
                               choices=c("Value"=1,
                                         "Structure"=2,
                                         "Metric"=3,
                                         "Patient ID"=4),
                               multiple=TRUE,
                               options=c(placeholder='Click to select variables'))
            ),
            conditionalPanel(condition="input.task == 'Show DVH'",
                h4("Plot options"),
                h5("Plot by patient or by structure"),
                radioButtons("plotByPat", "",
                             list("By patient"=1,
                                  "By structure"=2)),
                uiOutput("plotSelPat"),
                uiOutput("plotSelStruct"),
                h5("Plot relative/absolute volume"),
                radioButtons("plotPlotVol", "",
                             list("Relative volume"=1,
                                  "Absolute volume"=2)),
                h5("Threshold volume"),
                sliderInput("plotThreshVol", label="",
                            min=0, max=100, value=1),
                h5("DVH type"),
                radioButtons("plotType", "",
                             list("Cumulative"=1,
                                  "Differential"=2))
            ),
            conditionalPanel(condition="input.task == 'Check constraints'",
                h4("Define constraints"),
                radioButtons("constrIn", "",
                             list("Use built-in constraints"=1,
                                  "Upload constraints"=2,
                                  "Paste constraints"=3)),
                conditionalPanel(condition="input.constrIn == '2'",
                                 h5("Upload constraints: "),
                                 fileInput("constrUpload", "Select constraint file:", multiple=FALSE),
                                 radioButtons("constrDec", "Decimal separator:",
                                              list("."=1, ","=2)),
                                 radioButtons("constrSep", "Column separator:",
                                              list("\\t"=1, "' '"=2, ","=3, ";"=4),
                                              selected=2)),
                conditionalPanel(condition="input.constrIn == '3'",
                                 h5("Paste constraints:"),
                                 tags$textarea(id="constrPaste", rows=4, cols=10, ""),
                                 radioButtons("constrPasteDec", "Decimal separator:",
                                              list("."=1, ","=2)),
                                 radioButtons("constrPasteSep", "Column separator:",
                                              list("\\t"=1, "' '"=2, ","=3, ";"=4),
                                              selected=2)),
                actionButton("applyConstraints", "Apply"),
                h4("Output table options"),
                checkboxInput("constrSemSign", "Semantic negative sign", TRUE),
                selectizeInput("constrOut", label=h5("Select table columns"),
                               choices=constrOut, multiple=TRUE,
                               selected=c("1", "2", "3", "4", "5", "7", "9", "10"), width="100%"),
                selectizeInput("constrSortBy", label=h5("Sort output table by:"),
                               choices=c("Compliance"=1,
                                         "Structure"=2,
                                         "Constraint"=3,
                                         "Patient ID"=4,
                                         "delta volume"=5,
                                         "delta dose"=6,
                                         "Observed"=7),
                               multiple=TRUE,
                               options=c(placeholder='Click to select variables'))
            ),
            conditionalPanel(condition="input.task == 'Show constraints'",
                h4("Plot options"),
                h5("Plot by patient or by structure"),
                radioButtons("constrByPat", "",
                             list("By patient"=1,
                                  "By structure"=2)),
                h5("Plot relative/absolute volume"),
                radioButtons("constrPlotVol", "",
                             list("Relative volume"=1,
                                  "Absolute volume"=2)),
                h5("Threshold volume"),
                sliderInput("constrThreshVol", label="",
                            min=0, max=100, value=1)
            ),
            conditionalPanel(condition="input.task == 'About'",
                h4("Background info")
            )
        ),

        mainPanel(
            tabsetPanel(
                tabPanel("DVH data",
                    h6("Information from imported DVH file(s)"),
                    verbatimTextOutput("DVHinfo")
                ),
                tabPanel("Metrics",
                    h6("Calculate metrics"),
                    dataTableOutput("metrics"),
                    downloadButton("saveMetrics", "Save as text file"),
                    inputPanel(
                    radioButtons("saveMetrDec", "Decimal separator:",
                                 list("."=1, ","=2)),
                    radioButtons("saveMetrSep", "Column separator:",
                                 list("\\t"=1, "' '"=2, ","=3, ";"=4)))
                ),
                tabPanel("Show DVH",
                    h6("Show cumulative DVH diagrams"),
                    downloadButton("saveDVHPDF", "Save as PDF"),
                    downloadButton("saveDVHJPG", "Save as JPEGs (zipped to one file)"),
                    #plotOutput("DVHplotOrg"),
                    uiOutput("DVHplot")
                ),
                tabPanel("Check constraints",
                    h6("Check constraints"),
                    dataTableOutput("constraints"),
                    downloadButton("saveConstrTxt", "Save as text file"),
                    inputPanel(
                    radioButtons("saveConstrDec", "Decimal separator:",
                                 list("."=1, ","=2)),
                    radioButtons("saveConstrSep", "Column separator:",
                                 list("\\t"=1, "' '"=2, ","=3, ";"=4)))
                ),
                tabPanel("Show constraints",
                    h6("Show constraints in DVH diagrams"),
                    downloadButton("saveConstrPDF", "Save as PDF"),
                    downloadButton("saveConstrJPG", "Save as JPEGs (zipped to one file)"),
                    #plotOutput("constraintPlotOrg"),
                    uiOutput("constraintPlot")
                ),
                tabPanel("About",
                    h6("About DVHmetrics"),
                    p("This web application is a front-end for the",
                       a("R", href="http://www.r-project.org/"),
                       "package",
                       a("DVHmetrics", href="https://github.com/dwoll/DVHmetrics"),
                       "that provides functionality for radiation oncology:
                       Use it to read dose-volume-histogram (DVH) text files,
                       to calculate free DVH metrics, to show DVH diagrams,
                       to check and visualize quality assurance constraints
                       for the DVH."),
                    p(a("DVHmetrics", href="https://github.com/dwoll/DVHmetrics"),
                      "and this web application are written by:"),
                    p("Daniel", HTML("Wollschl&auml;ger"),
                      a("<wollschlaeger@uni-mainz.de>", href="mailto:wollschlaeger@uni-mainz.de"), br(),
                      "Institute for Medical Statistics, Epidemiology und Informatics (IMBEI)", br(),
                      "University Medical Center Mainz", br(),
                      "Germany"),
                    p("Heiko Karle",
                      a("<karle@uni-mainz.de>", href="mailto:karle@uni-mainz.de"), br(),
                      "Department of Radiation Oncology", br(),
                      "University Medical Center Mainz", br(),
                      "Germany"),
                    p("Data courtesy of Department of Radiation Oncology (Prof. Dr. Schmidberger), University Medical Center Mainz, Germany."),
                    p("Source code at",
                    a("https://github.com/dwoll/DVHshiny/",
                      href="https://github.com/dwoll/DVHshiny/")),
                    br(),
                    h6("Acknowledgements"),
                    p("Thanks to Marcus Stockinger for testing and feedback,",
                      "to Sandra Bührdel for Caplan DVH files, and to Hannes Rennau",
                      "for Masterplan DVH files"),
                    h6("References"),
                    p("This web application is built with R and shiny. The",
                      a("DVHmetrics", href="https://github.com/dwoll/DVHmetrics"),
                      "package uses functionality provided by the R packages ggplot2, reshape2,
                      and grid:"),
                    p("R Core Team (2014). R: A language and environment for statistical computing.
                       R Foundation for Statistical Computing, Vienna, Austria.", br(),
                       a("http://www.R-project.org/", href="http://www.R-project.org/")),
                    p("RStudio Inc. (2014). shiny: Web Application Framework for R.
                       R package version 0.11.", br(),
                       a("http://CRAN.R-project.org/package=shiny", href="http://CRAN.R-project.org/package=shiny"), br(),
                       a("http://shiny.rstudio.com/", href="http://shiny.rstudio.com/")),
                    p("Wickham, H (2007). Reshaping Data with the reshape Package.
                       Journal of Statistical Software, 21(12), 1-20.", br(),
                       a("http://www.jstatsoft.org/v21/i12/", href="http://www.jstatsoft.org/v21/i12/"), br(),
                       a("http://cran.r-project.org/package=reshape2", href="http://cran.r-project.org/package=reshape2")),
                    p("Wickham, H (2009). ggplot2: elegant graphics for data analysis.
                       New York: Springer.", br(),
                       a("http://ggplot2.org/", href="http://ggplot2.org/"), br(),
                       a("http://cran.r-project.org/package=ggplot2", href="http://cran.r-project.org/package=ggplot2"))
                ),

                id="task"
            )
        )
    )
))
