% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{plot.DTSg}
\alias{plot.DTSg}
\alias{plot}
\title{Plot Time Series}
\usage{
\method{plot}{DTSg}(x, from = first(self$values(TRUE)[[1L]]),
  to = last(self$values(TRUE)[[1L]]), cols = self$cols(class =
  "numeric"), secAxisCols = NULL, secAxisLabel = "", ...)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{from}{A \code{\link{POSIXct}} date with the same time zone as the time
series or a character string coercible to one. The time series is plotted
from this date on.}

\item{to}{A \code{\link{POSIXct}} date with the same time zone as the time
series or a character string coercible to one. The time series is plotted
up to this date.}

\item{cols}{A character vector specifying the columns whose values shall be
plotted.}

\item{secAxisCols}{A character vector specifying the columns whose values
shall be plotted on a secondary axis. Must be a subset of \code{cols}.}

\item{secAxisLabel}{A character string specifying the label of the secondary
axis.}

\item{\dots}{Not used (S3 method only).}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Displays an interactive plot of a \code{\link{DTSg}} object. This method
 requires \pkg{xts}, \pkg{dygraphs} and \pkg{RColorBrewer} to be installed.
 Its main purpose is not to make pretty plots, but rather to offer a
 possibility to interactively explore time series. The title of the plot and
 the label of its primary axis is automatically generated out of the object's
 metadata (fields). See \code{\link{DTSg}} for further information.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# plot time series
if (requireNamespace("xts", quietly = TRUE) &&
    requireNamespace("dygraphs", quietly = TRUE) &&
    requireNamespace("RColorBrewer", quietly = TRUE)) {
  ## R6 method
  x$plot()

  ## S3 method
  plot(x = x)
}

}
\seealso{
\code{\link{DTSg}}, \code{\link[dygraphs]{dygraph}},
 \code{\link{POSIXct}}, \code{\link{cols}}
}
